% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LTRE_fns.R
\name{classicalLTRE_random}
\alias{classicalLTRE_random}
\title{Classical LTRE analysis: random design}
\usage{
classicalLTRE_random(Aobj)
}
\arguments{
\item{Aobj}{An object containing all the population projection matrices to be
included in the analysis. It should either be a list, or a matrix where each
row is the column-wise vectorization of a matrix. Any set of 2 or more
matrices can be provided. The set of matrices passed in must all have the
same dimensions.}
}
\value{
A matrix of contributions to variance in lambda.
}
\description{
Life Table Response Experiments (LTREs) are a method of comparative demographic
analysis. The purpose is to quantify how the difference or variance in vital
rates (stage-specific survival, growth, and fertility) among populations
contributes to the difference or variance in the population growth rate, "lambda."
The equations and descriptions for the classical methods of LTRE analysis
can be found in Caswell's 2001 textbook.
}
\details{
Lambda is the asymptotic population growth rate, defined as the
largest eigenvalue of the population projection matrix.

A random design LTRE decomposes the variance in lambda due to variance and
covariance in the entries at each position in the matrices. For a random
design LTRE, at least 2 matrices must be provided. The matrix of
contributions returned from a classical method random design LTRE will
include both first-order terms (due to variance) and interaction terms (due
to covariance). Therefore, if the provided matrix is 3x3, the matrix of
contributions will be 9x9 (the size of the variance-covariance matrix is the
square of the size of the original matrix). The contributions of variances
are found on the diagonal of the contribution matrix, and the contributions
of covariances are symmetric. So the contribution of covariance between two
vital rate parameters is the sum of the two corresponding off-diagonal terms.

The equations and descriptions for the classical methods of LTRE analysis
can be found in Caswell's 2001 textbook.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A3<- matrix(data=c(0,0.4,0, 0,0,0.6, 6,0,0.25), nrow=3, ncol=3)
# contributions to the variance of lambda
cont_var<- classicalLTRE(list(A1,A2,A3), method='random')
}
