% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lttPlot.R
\name{lttPlot}
\alias{lttPlot}
\title{Make a lineage through time (LTT) plot}
\usage{
lttPlot(
  phy,
  lwd = 1,
  col = "red",
  plot = TRUE,
  rel.time = FALSE,
  add = FALSE,
  knitr = FALSE
)
}
\arguments{
\item{phy}{A \code{phylo} object, as specified by the \code{ape} package.}

\item{lwd}{Line width.}

\item{col}{Line color.}

\item{plot}{A \code{logical} indicating with calculations should be plotted.
If \code{FALSE}, function returns a list of the calculated points.}

\item{rel.time}{A \code{logical} indicating how the time scale should be
shown. If \code{FALSE} (default), plots the absolute time since \code{phy}'s
crown age. If  \code{TRUE}, plots time as a relative proportion between
crown age and furthest tip from root.}

\item{add}{A \code{logical} indicating if plot should be added to
pre-existing plot. Default is \code{FALSE}.}

\item{knitr}{Logical indicating if plot is intended to show up in RMarkdown files made by the \code{Knitr} R package.}
}
\value{
Plots the sum of alive lineages per point in time, and adds a red
line as a reference of expectation under pure birth. If \code{plot = FALSE},
a list the richness of each point in time, and \code{phy}'s crown age.
}
\description{
\code{lttPlot} plots the lineage through time (LTT) of a \code{phylo} object.
It also adds a reference line connecting the edges of the graph.
}
\examples{

S <- 1
E <- 0
set.seed(1)
phy <- simulateTree(pars = c(S, E), max.taxa = 20, max.t = 5)
lttPlot(phy, knitr = TRUE)
lttPlot(phy, plot = FALSE, knitr = TRUE)

}
\references{
Paradis, E. (2012). Analysis of Phylogenetics and Evolution with R (Vol. 2).
New York: Springer.
}
\author{
Daniel Rabosky, Matheus Januario, Jennifer Auler
}
