% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSpeciation.R
\name{estimateSpeciation}
\alias{estimateSpeciation}
\title{Estimate speciation assuming a pure-birth process}
\usage{
estimateSpeciation(phy)
}
\arguments{
\item{phy}{A \code{phylo} object, following terminology from package
\code{ape} in which function will operate.}
}
\value{
A \code{numeric} with the estimated speciation rate.
}
\description{
\code{estimateSpeciation} Estimates the speciation rate assuming a
constant-rate, pure-birth model.
}
\examples{
S <- 1
E <- 0
set.seed(1)
phy <- simulateTree(pars = c(S, E), max.taxa = 6, max.t = 5)
estimateSpeciation(phy)

}
\references{
Yule G.U. 1925. A mathematical theory of evolution, based on the conclusions of Dr. JC Willis, FRS. Philosophical Transactions of the Royal Society of London. Series B, Containing Papers of a Biological Character. 213:21–87.
}
\author{
Daniel Rabosky, Matheus Januario, Jennifer Auler
}
