#' Whale body size and speciation rates
#'
#' Data on the body size of many cetacean species and species-specific 
#' speciation rates. This dataset is part of the package and is licensed 
#' under the Creative Commons Attribution 4.0 International License (CC BY 4.0).
#'
#' @format
#' A \code{data.frame} with 75 rows and 4 columns. 
#' \describe{
#'   \item{species}{Whale species}
#'   \item{log_mass}{Log of body mass (grams)}
#'   \item{S}{Species-specific speciation rate}
#'   \item{color}{Suggested color to be used for the tip's clade}
#' }
#' @source Compilation of many primary sources (see details).
#' 
#' @details 
#' Species follow taxonomy from Steeman et al (2009). 
#' Species-specific speciation rates from Rabosky 2014 & Rabosky 
#' et al, 2014. Mass data from PanTHERIA (Jones et al, 2009).
#' 
#' @references 
#'  Jones, K. E., Bielby, J., Cardillo, M., Fritz, S. A., O'Dell, J., Orme, C. D. L., ... & Purvis, A. (2009). PanTHERIA: a species‐level database of life history, ecology, and geography of extant and recently extinct mammals: Ecological Archives E090‐184. Ecology, 90(9), 2648-2648.
#'  
#'  Rabosky, D. L. (2014). Automatic detection of key innovations, rate shifts, and diversity-dependence on phylogenetic trees. PLoS one, 9(2), e89543.
#'  
#'  Rabosky, D. L., Grundler, M., Anderson, C., Title, P., Shi, J. J., Brown, J. W., ... & Larson, J. G. (2014). BAMM tools: an R package for the analysis of evolutionary dynamics on phylogenetic trees. Methods in Ecology and Evolution, 5(7), 701-707.
#'  
#'  Steeman, M. E., Hebsgaard, M. B., Fordyce, R. E., Ho, S. Y., Rabosky, D. L., Nielsen, R., ... & Willerslev, E. (2009). Radiation of extant cetaceans driven by restructuring of the oceans. Systematic biology, 58(6), 573-585.
"data_whales"

#' Whale Phylogeny
#'
#' An ultrametric phylogenetic tree of the living cetaceans. Phylogeny 
#' generated by Steeman et al (2009). This dataset is part of the package and is licensed 
#' under the Creative Commons Attribution 4.0 International License (CC BY 4.0).
#'
#' @format
#' An ultrametric \code{phylo} object with 87 tips
#' 
#' @source Original phylogeny generation by Steeman et al (2001). 
#' File obtained from Rabosky et al, 2014. 
#' 
#' @references 
#'  Rabosky, D. L., Grundler, M., Anderson, C., Title, P., Shi, J. J., Brown, J. W., ... & Larson, J. G. (2014). BAMM tools: an R package for the analysis of evolutionary dynamics on phylogenetic trees. Methods in Ecology and Evolution, 5(7), 701-707.
#'  
#'  Steeman, M. E., Hebsgaard, M. B., Fordyce, R. E., Ho, S. Y., Rabosky, D. L., Nielsen, R., ... & Willerslev, E. (2009). Radiation of extant cetaceans driven by restructuring of the oceans. Systematic biology, 58(6), 573-585.
"whale_phylo"

#' Cytochrome Oxidase sequences
#'
#' \code{cytOxidase} is a set of homologous protein sequences from the GENE 
#' cytochrome oxidase SUBUNIT 1 gene. This mitochondrial gene, often known as 
#' CO1 (“see-oh-one”),  plays a key role in cellular respiration. C01 contains 
#' approximately 513 aminoacids and has been used by previous studies for 
#' reconstructing phylogenetic trees and estimating divergence times in 
#' Metazoaria by assuming a molecular clock. Its 5' partition is used for the 
#' ‘Barcoding of Life’ initiative, for instance. This dataset is part of the 
#' package and is licensed under the Creative Commons Attribution 4.0 
#' International License (CC BY 4.0).
#' 
#' @details The object of class "ProteinSeq" is structured as a named 
#' \code{vector} of 17 different animal species, with each individual component 
#' being a sequence of 513 aminoacids. 
#'
#' @format
#' A  object of class "ProteinSeq" with 17 entries, each representing 
#' a different animal species
#' \describe{
#'   \item{names}{Organism's popular name or a taxonomic classification}
#'   \item{sequence}{Aminoacid sequence of length 513}
#' }
#' 
#' @source Amino acid sequences were originally downloaded from genebank and later 
#' curated and aligned by Daniel L. Rabosky.
"cytOxidase"

#########################################################

#' Birds species list
#'
#' @format
#' A \code{vector} containing the names of almost all (i.e., 9993) extant bird species, following Jetz et al. (2012) taxonomy. This dataset is part of the package and is 
#' licensed under the Creative Commons Attribution 4.0 International License (CC BY 4.0).
#' 
#' @source Actual file downloaded from \url{https://vertlife.org/data/}
#' 
#' @references 
#' Jetz, W., Thomas, G. H., Joy, J. B., Hartmann, K., & Mooers, A. O. (2012). The global diversity of birds in space and time. Nature, 491(7424), 444-448.
"birds_spp"

#' Occurrence of dinosaur fossils
#'
#' Many dinosaur (including avian species) fossil occurrences from different 
#' moments of the geological past. Much information (i.e., extra columns) was 
#' removed from the original dataset to make it more compact, but it can be 
#' fully accessed by the data URL. This dataset is part of the package and is 
#' licensed under the Creative Commons Attribution 4.0 International License 
#' (CC BY 4.0).
#'
#' @format
#' A \code{data.frame} containing 15527 rows and 13 columns
#' \describe{
#'   \item{phylum}{Organism phylum}
#'   \item{class}{Organism taxonomic class}
#'   \item{order}{Organism taxonomic order}
#'   \item{family}{Organism taxonomic family}
#'   \item{genus}{Organism genus}
#'   \item{species}{Organism specific name}
#'   \item{early_interval}{Earlier known geological period of occurrence}
#'   \item{late_interval}{Later known geological period of occurrence}
#'   \item{max_ma}{Occurrence's oldest time boundary in million years}
#'   \item{min_ma}{Occurrence's newest time boundary in million years}
#'   \item{midpoint}{Midpoint between max_ma and min_ma}
#'   \item{lng}{Longitude of place where occurrence was found. Follows decimal degree format.}
#'   \item{lat}{Latitude of place where occurrence was found. Follows decimal degree format.}
#' }
#' @source The Paleobiology Database (downloaded on 2022-03-11). \cr
#' Data URL: http://paleobiodb.org/data1.2/occs/list.csv?datainfo&rowcount&base_name=Dinosauria&show=full,classext,genus,subgenus,acconly,ident,img,etbasis,strat,lith,env,timebins,timecompare,resgroup,ref,ent,entname,crmod \cr
"dinos_fossil"


#' Fossil Time series
#'
#' Values of clade diversity for many clades of organisms (note some clades 
#' are nested within other clades in the dataset). This dataset is part of the 
#' package and is licensed =under the Creative Commons Attribution 4.0 
#' International License (CC BY 4.0).
#'
#' @format
#' A \code{data.frame} with 598 rows and 6 columns. 
#' \describe{
#'   \item{clade}{Time series clade}  
#'   \item{source}{Primary source of the Time series}
#'   \item{stem_age}{Stem age of clade}
#'   \item{rel_time}{Geological relative time (in Million years ago relative to present)}
#'   \item{time_ma}{Geological time in million years since clade stem age}
#'   \item{richness}{Number of species at given geological time}
#' }
#' 
#' @details Legend: \cr
#' anth = Anthozoa (Cnidaria); \cr
#' art = Articulata (Crinoidea, Echinodermata); \cr 
#' biv = Bivalvia (Mollusca); \cr 
#' bryo = Bryozoa (Lophotrochozoa, Ectoprocta); \cr 
#' ceph = Cephalopoda (Mollusca); \cr 
#' chon = Chondrocytes (Chordata); \cr 
#' crin = Crinoidea (Echinodermata); \cr 
#' dinosauria = Dinosauria (Chordata); \cr 
#' ech = Echinoidea (Echinodermata); \cr 
#' foram = Foraminifera (Retaria); \cr 
#' gast = Gastropoda (Mollusca); \cr 
#' graptoloids = Graptolites (Graptolithina); \cr 
#' ling = Ligulata (Brachiopoda); \cr 
#' ostr = Ostracoda (Crustacea, Arthropoda); \cr 
#' tril = Trilobita (Arthropoda). \cr
#' 
#' 
#' @source Data originally compiled from many primary sources. Organized, curated by, and downloaded from, Rabosky & Benson (2021).
#' 
#' @references 
#' Rabosky, D. L., & Benson, R. B. (2021). Ecological and biogeographic drivers of biodiversity cannot be resolved using clade age-richness data. Nature Communications, 12(1), 2945.
"timeseries_fossil"