% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_test.R
\name{evidence_test}
\alias{evidence_test}
\title{Likelihood-based evidence ratio test}
\usage{
evidence_test(...)
}
\arguments{
\item{...}{Arguments defining the data and model.}
}
\value{
An object of class \code{evidence_result}.
}
\description{
Computes an effect estimate, a Wald-style uncertainty interval, and a
likelihood-based evidence ratio (log10 scale) from a single statistical model.
}
\examples{
x <- sleep$extra[sleep$group == 1]
evidence_test(x)

tbl <- matrix(c(30, 70, 20, 80), nrow = 2)
evidence_test(tbl)

evidence_test(mpg ~ wt, data = mtcars, coef = "wt")

}
