% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_era5_land.R
\name{download_era5_land}
\alias{download_era5_land}
\title{ERA5-Land data downloader}
\usage{
download_era5_land(
  path = "",
  domain = "raw",
  time_res = "monthly",
  variable = "e"
)
}
\arguments{
\item{path}{a character string with the path where the data will be downloaded.}

\item{domain}{a character string with the desired domain data set. Suitable options are:
\itemize{
\item{"raw" for default available spatial coverage,}
\item{"global" for data sets with global (land and ocean) coverage,}
\item{"land" for data sets with land only coverage,}
\item{"ocean", for data sets with ocean only coverage.}
}}

\item{time_res}{a character string with the desired time resolution. Suitable options are:
\itemize{
\item{"monthly",}
\item{"yearly",}
\item{"daily".}
}}

\item{variable}{a character string for the variable. Suitable options are:
\itemize{
\item{"e" for actual evapotranspiration,}
\item{"pet" for potential evapotranspiration.}
}}
}
\value{
No return value, called to download the data set.
}
\description{
Downloading ERA5-Land evapotranspiration data
}
\keyword{internal}
