% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logdetPaceBarry.R
\name{logdetPaceBarry}
\alias{logdetPaceBarry}
\title{Pace and Barry's log determinant approximation}
\usage{
logdetPaceBarry(W, length.out = 200, rmin = -1, rmax = 1)
}
\arguments{
\item{W}{numeric \eqn{n} by \eqn{n} non-negative spatial weights matrix,
with zeros on the main diagonal.}

\item{length.out}{single, integer number, has to be at least 51 (due to order
of approximation). Sets how fine the grid approximation is. Default
value is 200.}

\item{rmin}{single number between -1 and 1. Sets the minimum value of the
spatial autoregressive parameter \eqn{\rho}. Has to be lower than
\code{rmax}. Default value is -1.}

\item{rmax}{single number between -1 and 1. Sets the maximum value of the
spatial autoregressive parameter \eqn{\rho}. Has to be higher than
\code{rmin}. Default value is 1.}
}
\value{
numeric \code{length.out} by  \code{2} matrix; the first column
  contains the approximated log-determinants the second column the \eqn{\rho} values
  ranging between \code{rmin} and \code{rmax}.
}
\description{
Bayesian estimates of parameters of SAR and SDM type spatial models require the computation
of the log-determinant of positive-definite spatial projection matrices of the form
\eqn{(I_n - \rho W)}, where \eqn{W} is a \eqn{n} by \eqn{n} spatial weight matrix. However, direct computation
of the log-determinant is computationally expensive.
}
\details{
This function wraps the log-determinant approximation by Barry and Pace (1999), which
can be used to pre-compute the log-determinants over a grid of \eqn{\rho} values.
}
\references{
Barry, R. P., and Pace, R. K. (1999) Monte Carlo estimates of the
log determinant of large sparse matrices. \emph{Linear Algebra and its
applications}, \bold{289(1-3)}, 41-54.
}
