% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6_samplers.R
\docType{class}
\name{W_sampler}
\alias{W_sampler}
\title{An R6 class for sampling the elements of \eqn{W}}
\format{
An \code{\link[R6]{R6Class}} generator object
}
\description{
An R6 class for sampling the elements of \eqn{W}

An R6 class for sampling the elements of \eqn{W}
}
\details{
This class samples the spatial weight matrix. Use the function \link{W_priors} class for setup.

The sampling procedure relies on conditional Bernoulli posteriors outlined in
Krisztin and Piribauer (2022).
}
\references{
Krisztin, T., and Piribauer, P. (2022) A Bayesian approach for the estimation
 of weight matrices in spatial autoregressive models. \emph{Spatial Economic Analysis}, 1-20.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{W_prior}}{The current \code{\link{W_priors}}}

\item{\code{curr_w}}{numeric, non-negative \eqn{n} by \eqn{n} spatial weight matrix with zeros
on the main diagonal. Depending on the \code{\link{W_priors}} settings can be symmetric and/or
row-standardized.}

\item{\code{curr_W}}{binary \eqn{n} by \eqn{n} spatial connectivity matrix \eqn{\Omega}}

\item{\code{curr_A}}{The current spatial projection matrix \eqn{I - \rho W}.}

\item{\code{curr_AI}}{The inverse of \code{curr_A}}

\item{\code{curr_logdet}}{The current log-determinant of \code{curr_A}}

\item{\code{curr_rho}}{single number between -1 and 1 or NULL, depending on whether the sampler updates
the spatial autoregressive parameter \eqn{\rho}. Set while invoking \code{initialize}
or using the function \code{set_rho}.}

\item{\code{spatial_error}}{Should a spatial error model be constructed? Defaults to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-W_sampler-new}{\code{W_sampler$new()}}
\item \href{#method-W_sampler-set_rho}{\code{W_sampler$set_rho()}}
\item \href{#method-W_sampler-sample}{\code{W_sampler$sample()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-W_sampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-W_sampler-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{W_sampler$new(W_prior, curr_rho = NULL, spatial_error = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{W_prior}}{The list returned by \code{\link{W_priors}}}

\item{\code{curr_rho}}{Optional single number between -1 and 1. Value of the spatial autoregressive
parameter \eqn{\rho}. Defaults to NULL, in which case no updates of the log-determinant, the spatial
 projection matrix, and its inverse are carried out.}

\item{\code{spatial_error}}{Optional binary, specifying whether the sampler is for a spatial
error model (TRUE) or for a spatial autoregressive specification (FALSE).
Defaults to FALSE. If \code{spatial_error = TRUE} then a value \code{curr_rho} has to be supplied
at initialization.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-W_sampler-set_rho"></a>}}
\if{latex}{\out{\hypertarget{method-W_sampler-set_rho}{}}}
\subsection{Method \code{set_rho()}}{
If the spatial autoregressive parameter \eqn{\rho} is updated during the sampling procedure the log determinant, the
spatial projection matrix \eqn{I - \rho W} and it's inverse must be updated. This function should be
used for a consistent update. At least the new scalar value for \eqn{\rho} must be supplied.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{W_sampler$set_rho(new_rho, newLogdet = NULL, newA = NULL, newAI = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_rho}}{single, number; must be between -1 and 1.}

\item{\code{newLogdet}}{An optional value for the log determinant corresponding to \code{newW} and \code{curr_rho}}

\item{\code{newA}}{An optional value for the spatial projection matrix using \code{newW} and \code{curr_rho}}

\item{\code{newAI}}{An optional value for the matrix inverse of \code{newA}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-W_sampler-sample"></a>}}
\if{latex}{\out{\hypertarget{method-W_sampler-sample}{}}}
\subsection{Method \code{sample()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{W_sampler$sample(Y, curr_sigma, mu, lag_mu = matrix(0, nrow(tY), ncol(tY)))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y}}{The \eqn{n} by \eqn{tt} matrix of responses}

\item{\code{curr_sigma}}{The variance parameter \eqn{\sigma^2}}

\item{\code{mu}}{The \eqn{n} by \eqn{tt} matrix of means.}

\item{\code{lag_mu}}{\eqn{n} by \eqn{tt} matrix of means that will be spatially lagged with
the estimated \eqn{W}. Defaults to a matrix with zero elements.}
}
\if{html}{\out{</div>}}
}
}
}
