% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxygen.R
\docType{methods}
\name{ernm-formula}
\alias{ernm-formula}
\title{ERNM formula}
\description{
ERNM formula
}
\section{Formula}{


ERNM models are specified using a formula interface. The formula expresses what statistics are in the model,
along with any parameters that the statistics take. It also defines what nodal covariates are considered random
and if the edges are considered random. Finally, it specifies the network that the model is defined on.

The format of the formula follows the pattern

..network.. ~ ..statistics.. | ..random..

The ..network.. place should be a single object that can be coerced into a native ernm network using as.BinaryNet.

The ..statistics.. place may contain any statistic supported by the package (see \code{\link{ernm-terms}}). Multiple statistics may be added
by separating them with "+".

The ..random.. place defines what is considered random within the network. By default the dyads are considered random,
however, this may be changed by including noDyad in the random place. Additionally, the names of vertex attributes
can be added to make them stochastic.

For example, a simple erdos-renyi random graph model can be specified on the samplike dataset (see data(samplike)) by

samplike ~ edges()

A simple multinomial ALAAM model for the group variable can be specified by setting the dyads to be fixed and group to be random.

samplike ~ nodeCount("group") | noDyad + group

A full ernm model with terms for edges, triangles, and homopily looks like

samplike ~ edges() + triangles() + nodeCount("group") + homophily("group")
}

