% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{nvertex}
\alias{nvertex}
\alias{nedges}
\alias{nnets}
\alias{is_directed}
\title{Utility functions to query network dimensions}
\usage{
nvertex(x)

nedges(x, ...)

nnets(x)

is_directed(x, check_type = FALSE)
}
\arguments{
\item{x}{Either an object of class \link{ergmito}, \code{\link[network:network]{network::network()}}, \code{\link[stats:formula]{stats::formula()}}, or \code{\link[base:matrix]{base::matrix()}}.}

\item{...}{Further arguments passed to the method. Currently only \code{nedges.network}
receives arguments (see \link[network:network.edgecount]{network::network.edgecount}).}

\item{check_type}{Logical scalar. When checking for whether the network is
directed or not, we can ask the function to return with an error if what we
are checking is not an object of class network, otherwise it simply returns
false.}
}
\value{
\code{is_directed} checks whether the passed networks are directed using
the function \code{\link[network:network.indicators]{is.directed}}. In the case of multiple networks,
the function returns a logical vector. Only objects of class \code{network} can be
checked, otherwise, if \code{check_type = FALSE}, the function returns \code{TRUE} by default.
}
\description{
Utility functions to query network dimensions
}
\examples{
set.seed(771)
net <- lapply(rbernoulli(c(4, 4)), network::network, directed = FALSE)
is_directed(net)
is_directed(net[[1]])
is_directed(net ~ edges)
\dontrun{
  is_directed(net[[1]][1:4, 1:4], check_type = TRUE) # Error
}
is_directed(net[[1]][1:4, 1:4])
}
