% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitWtErgmTerm_rank.R
\name{rank.inconsistency-ergmTerm}
\alias{rank.inconsistency-ergmTerm}
\alias{InitWtErgmTerm.rank.inconsistency}
\title{(Weighted) Inconsistency}
\usage{
# valued: rank.inconsistency(x, attrname, weights, wtname, wtcenter)
}
\arguments{
\item{x, attrname}{a specification for the reference ranking: either
one of the following, or the name of a network attribute
containing one of the following: \describe{

\item{a matrix}{with dimensions \eqn{n \times n}{n*n}
for unipartite networks and \eqn{b \times (n-b)}{b*(n-b)} for
bipartite networks; \code{attrname}, if given, is used to construct
the term name.}

\item{a network object}{with the same size and bipartitedness as
LHS; \code{attrname}, if given, provides the name of the
quantitative edge attribute to use for reference rankings values (in
this case, missing edges in \code{x} are assigned a rank value
of zero).}

}}

\item{weights}{optional parameter to weigh the counts. Can be either a 3D \eqn{n\times n\times n}-array
whose \eqn{(i,j,k)} th element gives the weight for the
comparison by \eqn{i} of \eqn{j} and \eqn{k} or a function taking
three arguments, \eqn{i}, \eqn{j}, and \eqn{k}, and returning
the weight of this comparison.}

\item{wtname, wtcenter}{If \code{wtcenter=TRUE} , the
calculated weights will be centered around their
mean. \code{wtname} can be used to label this term.}
}
\description{
Measures the amount of disagreement between rankings of the focus
network and a fixed covariate network \code{x} , by couting the number of pairwise
comparisons for which the two networks disagree.
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "rank.inconsistency", "subsection")}
}
\concept{directed}
\concept{ordinal}
\concept{quantitative triadic attribute}
\concept{valued}
