% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eratosthenes.R
\name{finds_d2l}
\alias{finds_d2l}
\alias{finds_d2l.data.frame}
\title{Convert Finds Data Frame (Context / Find-Type) to List Object}
\usage{
finds_d2l(input)

\method{finds_d2l}{data.frame}(input)
}
\arguments{
\item{input}{A two-column data frame of contexts (first column) and find-types (second column). An optional third column of an id number may be provided.}
}
\value{
A list of finds (each one a list) associated with contexts and their types.
}
\description{
Performs the opposite of \code{\link[eratosthenes]{finds_l2d}}. Takes a \code{data.frame} object of two columns, containing the context in the first and the find-type in the second, and returns a \code{list} object for input in \code{\link[eratosthenes]{gibbs_ad}}. The value of the find \code{id} is automatically generated as an integer if not provided in a third column.
}
\examples{
f1 <- list(id = "find01", assoc = "D", type = c("type1", "form1"))
f2 <- list(id = "find02", assoc = "E", type = c("type1", "form2"))
f3 <- list(id = "find03", assoc = "G", type = c("type1", "form1"))
f4 <- list(id = "find04", assoc = "H", type = c("type2", "form1"))
f5 <- list(id = "find05", assoc = "I", type = "type2")
f6 <- list(id = "find06", assoc = "H", type = NULL)

artifacts <- list(f1, f2, f3, f4, f5, f6)

# convert list to data frame
artifacts_df <- finds_l2d(artifacts)

# convert data frame to list
artifacts_list <- finds_d2l(artifacts_df)

}
