% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_incubation.R
\name{empirical_incubation_dist}
\alias{empirical_incubation_dist}
\title{Extract empirical incubation period distribution from linelist data}
\usage{
empirical_incubation_dist(x, date_of_onset, exposure, exposure_end = NULL)
}
\arguments{
\item{x}{the linelist data (data.frame or linelist object) containing at
least a column containing the exposure dates and one containing the onset
dates.}

\item{date_of_onset}{the name of the column containing the onset dates (bare
variable name or in quotes)}

\item{exposure}{the name of the column containing the exposure dates
(bare variable name or in quotes)}

\item{exposure_end}{the name of a column containing dates representing the
end of the exposure period. This is `NULL` by default, indicating
all exposures are known and in the `exposure` column.}
}
\value{
a data frame containing a column with the different incubation
  periods and a column containing their relative frequency
}
\description{
This function takes in a linelist data frame and extracts the empirical
incubation period distribution and can take into account uncertainty in the
dates of exposure.
}
\note{
For exposure dates, each element can be a vector containing several
  possible exposure dates. Note that if the same exposure date appears twice
  in the list it is given twice as much weight.
}
\examples{
if (require(tibble)) {
random_dates <- as.Date("2020-01-01") + sample(0:30, 50, replace = TRUE)
x <- tibble(date_of_onset = random_dates)

# Linelist with a list column of potential exposure dates ------------------
mkexposures <- function(x) x - round(rgamma(sample.int(5, size = 1), shape = 12, rate = 3))
exposures <- sapply(x$date_of_onset, mkexposures)
x$date_exposure <- exposures

incubation_period_dist <- empirical_incubation_dist(x, date_of_onset, date_exposure)
incubation_period_dist

# Linelist with exposure range ---------------------------------------------
start_exposure   <- round(rgamma(nrow(x), shape = 12, rate = 3))
end_exposure     <- round(rgamma(nrow(x), shape = 12, rate = 7))
x$exposure_end   <- x$date_of_onset - end_exposure
x$exposure_start <- x$exposure_end - start_exposure
incubation_period_dist <- empirical_incubation_dist(x, date_of_onset, exposure_start, exposure_end)
incubation_period_dist
plot(incubation_period_dist,
     type = "h", lwd = 10, lend = 2, col = "#49D193",
     xlab = "Days since exposure",
     ylab = "Probability",
     main = "Incubation time distribution")
}
}
\author{
Flavio Finger, \email{flavio.finger@lshtm.ac.uk}, Zhian N. Kamvar
}
