% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validate_data}
\alias{validate_data}
\title{Validate input EpiTrax data}
\usage{
validate_data(data)
}
\arguments{
\item{data}{Dataframe. EpiTrax data to validate.}
}
\value{
The validated data with all unneeded columns removed.
}
\description{
'validate_data' checks the data for expected columns and data types, removes
unneeded columns, and returns the resulting data. Missing or NA values will be
removed with a warning.
Valid data must include the following columns (and types):
\itemize{
\item \code{patient_mmwr_year} (integer)
\item \code{patient_mmwr_week} (integer)
\item \code{patient_disease} (character)
}
}
\examples{
df <- data.frame(
  patient_mmwr_year = 2020L,
  patient_mmwr_week = 1L,
  patient_disease = "A"
)
validate_data(df)
}
