% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_ireport_annual_counts}
\alias{epitrax_ireport_annual_counts}
\title{Create annual counts internal report from an EpiTrax object}
\usage{
epitrax_ireport_annual_counts(epitrax)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}
}
\value{
Updated EpiTrax object with \code{annual_counts} added to the
\code{internal_reports} field.
}
\description{
\code{epitrax_ireport_annual_counts} generates an internal report of annual
counts for each disease in the EpiTrax object data.
}
\examples{
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
disease_lists <- list(
  internal = "use_defaults",
  public = "use_defaults"
)

epitrax <- setup_epitrax(
  filepath = data_file,
  config_file = config_file,
  disease_list_files = disease_lists
) |>
 epitrax_ireport_annual_counts()

epitrax$internal_reports$annual_counts
}
