% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{create_report_monthly_medians}
\alias{create_report_monthly_medians}
\title{Create monthly medians report}
\usage{
create_report_monthly_medians(data, diseases)
}
\arguments{
\item{data}{Dataframe. Input data with columns:
\itemize{
\item \code{disease} (character)
\item \code{year} (integer)
\item \code{month} (integer)
\item \code{counts} (integer)
}}

\item{diseases}{Character vector. Diseases to include in the report}
}
\value{
Dataframe of monthly medians with one row per disease and one column
per month (Jan through Dec).
}
\description{
'create_report_monthly_medians' generates a data frame of median monthly case
counts for each disease across all years in the input data. This provides a
more robust central tendency measure compared to averages for skewed data.
}
\examples{
data <- data.frame(
  disease = c("A", "A", "A", "B", "B", "B"),
  year = c(2022, 2023, 2024, 2022, 2023, 2024),
  month = c(1, 1, 1, 2, 2, 2),
  counts = c(10, 20, 30, 5, 15, 25)
)
create_report_monthly_medians(data, c("A", "B", "C"))
}
