% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{create_report_annual_counts}
\alias{create_report_annual_counts}
\title{Create annual counts report}
\usage{
create_report_annual_counts(data, diseases)
}
\arguments{
\item{data}{Dataframe. Input data with columns:
\itemize{
\item \code{disease} (character)
\item \code{year} (integer)
\item \code{month} (integer)
\item \code{counts} (integer)
}}

\item{diseases}{Character vector. Diseases to include in the report}
}
\value{
Dataframe of annual counts with one row per disease and one column
per year.
}
\description{
'create_report_annual_counts' generates a data frame of annual case
counts for each disease, with years as columns.
}
\examples{
data <- data.frame(
  disease = c("A", "A", "B"),
  year = c(2020, 2021, 2020),
  counts = c(5, 7, 8)
)
create_report_annual_counts(data, diseases = c("A", "B", "C"))
}
