% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{create_public_report_month}
\alias{create_public_report_month}
\title{Create a monthly cross-section public report}
\usage{
create_public_report_month(data, diseases, y, m, config)
}
\arguments{
\item{data}{Dataframe. Input data with columns:
\itemize{
\item \code{disease} (character)
\item \code{year} (integer)
\item \code{month} (integer)
\item \code{counts} (integer)
}}

\item{diseases}{Dataframe. Diseases to include in the report. Maps EpiTrax disease
names to public-facing versions. Must have columns:
\itemize{
\item \code{EpiTrax_name} (character)
\item \code{Public_name} (character)
}}

\item{y}{Integer. Report year}

\item{m}{Integer. Report month (1-12)}

\item{config}{List. Report settings}
}
\value{
List containing the report name and data.
}
\description{
'create_public_report_month' creates a public report for the given month.
}
\details{
Uses the following config options:
\itemize{
\item \code{current_population}
\item \code{avg_5yr_population}
\item \code{rounding_decimals}
\item \code{trend_threshold}
}
}
\examples{
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
# Read in EpiTrax data
data <- read_epitrax_data(data_file)

diseases <- data.frame(
  EpiTrax_name = c("Influenza", "COVID-19", "Measles", "Syphilis"),
  Public_name = c("Influenza", "COVID-19", "Measles", "Syphilis")
)
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                          package = "epitraxr")
config <- get_report_config(config_file)

create_public_report_month(
 data = data,
 diseases = diseases,
 y = 2024,
 m = 1,
 config = config
)
}
\seealso{
\code{\link[=get_month_counts]{get_month_counts()}}, \code{\link[=create_report_monthly_avgs]{create_report_monthly_avgs()}} which
this function uses and \code{\link[=epitraxr_config]{epitraxr_config()}} for config options
}
