% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{incidence_rate}
\alias{incidence_rate}
\title{Extends an incidence class object with incidence rates estimations.}
\usage{
incidence_rate(incidence_object, level, scale = 1e+05)
}
\arguments{
\item{incidence_object}{An incidence object.}

\item{level}{Administration level at which incidence counts are grouped
(0 = national, 1 = state/department, 2 = city/municipality).}

\item{scale}{Scale to consider when calculating the incidence_rate.}
}
\value{
A modified incidence object where counts are normalized with the
population.
}
\description{
Function that estimates incidence rates from a incidence class
object and population projections.
}
\examples{
data_event <- epiCo::epi_data
incidence_historic <- incidence::incidence(data_event$fec_not,
  groups = data_event$cod_mun_o,
  interval = "1 year"
)
incidence_object <- subset(incidence_historic,
  from = "2015-01-04",
  to = "2018-12-27"
)
inc_rate <- incidence_rate(incidence_object, level = 2, scale = 100000)
inc_rate$rates

}
