% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epanet.inp-s3.r
\name{read.inp}
\alias{read.inp}
\alias{epanet.inp}
\title{Read .inp file}
\usage{
read.inp(file)
}
\arguments{
\item{file}{the name of the file to read}
}
\value{
Returns an epanet.inp S3 object with 
elements of the following names and types corresponding to sections
of the .inp file. Sections missing from the .inp file have a value of NULL.
\item{Title}{character}
\item{Junctions}{data.frame}
\item{Tanks}{data.frame}
\item{Reservoirs}{data.frame}
\item{Pipes}{data.frame}
\item{Pumps}{data.frame}
\item{Valves}{data.frame}
\item{Demands}{data.frame}
\item{Status}{data.frame}
\item{Emitters}{data.frame}
\item{Quality}{data.frame}
\item{Sources}{data.frame}
\item{Reactions}{character}
\item{Mixing}{data.frame}
\item{Patterns}{list}
\item{Curves}{list}
\item{Controls}{character}
\item{Rules}{character}
\item{Energy}{character}
\item{Times}{character}
\item{Report}{character}
\item{Options}{list}
\item{Coordinates}{data.frame}
\item{Vertices}{data.frame}
\item{Labels}{data.frame}
\item{Backdrop}{character}
\item{Tags}{character}
}
\description{
Read an Epanet .inp file into R
}
\details{
This function reads a text file in Epanet's .inp format 
and returns an S3 object with entries for 
sections of the .inp file.  Sections of the .inp file that are implemented 
appear in the Value section.

Fields for node or link ID are stored as characters not factors or integers.
However, some fields are stored as factors
to allow more informative summaries. Examples include valve type and pipe status.  
       
Sections that are absent from the .inp file are NULL in the list.

Columns of data.frames use the headings exported by 
the Epanet GUI. 

The [OPTIONS] section in the .inp file is used to update
         a list of Epanet's default options. In this way if an option such as
         units is not specified by the .inp file, the units that would be used by
         default are provided.

In the [PATTERNS] and [CURVES] sections, integers used as names of list elements are backquoted
         according to the default behavior in R.  So if the .inp file has a pattern "1"
         this pattern will appear as element `1` in the list that is returned. A warning is issued in this case.
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanetReader"), "extdata","Net1.inp") 

#read the network file into R
n1 <- read.inp(inp)
summary(n1)
names(n1)
summary(n1$Junctions)
summary(n1$Pipes)
plot(n1) 
}
\references{
Rossman, L. A. (2000). Epanet 2 users manual. US EPA, Cincinnati, Ohio.

https://nepis.epa.gov/Adobe/PDF/P1007WWU.pdf
}
