% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getmzrt.R
\name{getfilter}
\alias{getfilter}
\title{Filter the data based on row and column index}
\usage{
getfilter(list, rowindex = TRUE, colindex = TRUE, name = NULL, type = "o", ...)
}
\arguments{
\item{list}{list with data as peaks list, mz, rt and group information}

\item{rowindex}{logical, row index to keep}

\item{colindex}{logical, column index to keep}

\item{name}{file name for csv and/or eic file, default NULL}

\item{type}{csv format for further analysis, m means  Metaboanalyst, a means xMSannotator, p means Mummichog(NA values are imputed by `getimputation`, and F test is used here to generate stats and p value), o means full information csv (for `pmd` package), default o. mapo could output all those format files.}

\item{...}{other parameters for `getcsv`}
}
\value{
list with remain peaks, and filtered peaks index
}
\description{
Filter the data based on row and column index
}
\examples{
data(list)
li <- getdoe(list)
lif <- getfilter(li,rowindex = li$rsdindex)
}
\seealso{
\code{\link{getimputation}}, \code{\link{getcsv}}
}
