% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_alpha.R
\name{stratified_alpha}
\alias{stratified_alpha}
\title{Stratified Cronbach's Coefficient Alpha}
\usage{
stratified_alpha(x, s)
}
\arguments{
\item{x}{A data frame or matrix containing item responses, with rows as
subjects and columns as items. Items are assumed to be ordered by stratum.}

\item{s}{A numeric vector giving the number of items in each stratum. The
sum of \code{s} must equal \code{ncol(x)}.}
}
\value{
A named list with:
\describe{
\item{stratified_alpha}{Stratified Cronbach's coefficient alpha.}
}
}
\description{
Compute the stratified Cronbach's coefficient alpha for a test composed of
several item strata (e.g., subtests or subscales).
}
\details{
Stratified alpha is an estimate of the internal consistency reliability of a
composite test formed by multiple item strata (e.g., subtests). Each stratum
reliability is computed using \code{alpha()}, and combined using the
classical stratified-alpha formula.
}
\examples{
data(data.m)
stratified_alpha(data.m, c(13, 12, 6))

}
