% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-google.R
\name{chat_google_gemini}
\alias{chat_google_gemini}
\alias{chat_google_vertex}
\alias{models_google_gemini}
\alias{models_google_vertex}
\title{Chat with a Google Gemini or Vertex AI model}
\usage{
chat_google_gemini(
  system_prompt = NULL,
  base_url = "https://generativelanguage.googleapis.com/v1beta/",
  api_key = NULL,
  credentials = NULL,
  model = NULL,
  params = NULL,
  api_args = list(),
  api_headers = character(),
  echo = NULL
)

chat_google_vertex(
  location,
  project_id,
  system_prompt = NULL,
  model = NULL,
  params = NULL,
  api_args = list(),
  api_headers = character(),
  echo = NULL
)

models_google_gemini(
  base_url = "https://generativelanguage.googleapis.com/v1beta/",
  api_key = NULL,
  credentials = NULL
)

models_google_vertex(location, project_id, credentials = NULL)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{base_url}{The base URL to the endpoint; the default is OpenAI's
public API.}

\item{api_key}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{credentials} instead.}

\item{credentials}{A function that returns a list of authentication headers
or \code{NULL}, the default, to use ambient credentials. See above for details.}

\item{model}{The model to use for the chat (defaults to "gemini-2.5-flash").
We regularly update the default, so we strongly recommend explicitly specifying a model for anything other than casual use.
Use \code{models_google_gemini()} to see all options.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{api_headers}{Named character vector of arbitrary extra headers appended
to every chat API call.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}

\item{location}{Location, e.g. \code{us-east1}, \code{me-central1}, \code{africa-south1} or
\code{global}.}

\item{project_id}{Project ID.}
}
\value{
A \link{Chat} object.
}
\description{
Google's AI offering is broken up into two parts: Gemini and Vertex AI.
Most enterprises are likely to use Vertex AI, and individuals are likely
to use Gemini.

Use \code{\link[=google_upload]{google_upload()}} to upload files (PDFs, images, video, audio, etc.)
\subsection{Authentication}{

These functions try a number of authentication strategies, in this order:
\itemize{
\item An API key set in the \code{GOOGLE_API_KEY} env var, or,
for \code{chat_google_gemini()} only, \code{GEMINI_API_KEY}.
\item Google's default application credentials, if the \pkg{gargle} package
is installed.
\item Viewer-based credentials on Posit Connect, if the \pkg{connectcreds}
package.
\item \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}. An browser-based OAuth flow, if
you're in an interactive session. This currently uses an unverified
OAuth app (so you will get a scary warning); we plan to verify in the
near future.
}
}
}
\examples{
\dontrun{
chat <- chat_google_gemini()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openai_compatible}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
