% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidate_fed.R
\name{candidate_fed}
\alias{candidate_fed}
\title{Download data on the candidates' background in federal elections}
\usage{
candidate_fed(
  year,
  uf = "all",
  br_archive = FALSE,
  encoding = "latin1",
  temp = TRUE
)
}
\arguments{
\item{year}{Election year. For this function, only the years 1994, 1998, 2002, 2006, 2010, 2014, 2018, and 2022
are available.}

\item{uf}{Federation Unit acronym (\code{character vector}).}

\item{br_archive}{In the TSE's data repository, some results can be obtained for the whole country by loading a single
within a single file by setting this argument to \code{TRUE} (may not work in for some elections and, in 
other, it recovers only electoral data for presidential elections, absent in other files).}

\item{encoding}{Data original encoding (defaults to 'latin1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). elections_rda}
}
\value{
\code{candidate_local()} returns a \code{data.frame}
}
\description{
\code{candidate_fed()} downloads and aggregates the data on the candidates' background who competed in the
federal elections in Brazil. The function returns a \code{data.frame} where each observation
corresponds to a candidate.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2002, some information can be incomplete. For the 2014, 2018, and 2022 elections, more variables are available.
}
\examples{
\dontrun{
df <- candidate_fed(2000)
}
}
