% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simula_BPF.R
\name{simula_BPF}
\alias{simula_BPF}
\title{Simulate RxC Tables from Overdispersed-Multinomial Models}
\usage{
simula_BPF(
  n.units,
  TM,
  prop1,
  polling.sizes,
  theta1 = 0.1,
  theta2 = 0.1,
  cs = 50,
  noise = 0,
  simplify = FALSE,
  ...
)
}
\arguments{
\item{n.units}{Either a positive integer number, \code{K}, indicating the number of polling units to be simulated, or
a \code{KxR} data.frame of a matrix with the number of votes gained in election 1
for each of the \code{R} options in each of the \code{K} units. If \code{n.units} is a matrix (data.frame) of
counts (votes) the values of arguments \code{prop1} and \code{theta1} are ommitted.}

\item{TM}{A row-standardized RxC matrix with the underlying global transition
probabilities of the simulated elections. If the matrix is not row-standardized,
it is internally row-standardized by the function.}

\item{prop1}{A vector of length R with the initial assumed probabilities of voting (to be simulated)
for each of the R competing options in the first election. If the provided vector
is not a set of probabilities (i.e., a vector of positive numbers adding to 1),
it is internally standardized by the function.}

\item{polling.sizes}{Either a vector of two components with two positive integer
numbers indicating the minimum and maximum number of voters
for each unit or a vector of length \code{n.units} of positive integer
numbers informing about the number of voters in each unit. When
\code{polling.sizes} is a vector of length two, a number of voters is
randomly assigned for each unit using a uniform distribution with
parameters the minimum and maximum values included in \code{polling.sizes}.}

\item{theta1}{A number between 0 and 1 used as the overdispersion parameter.
This parameter is employed by the underlying Dirichlet distribution,
in conjunction with \code{prop1}, to randomly generate vectors of probabilities
for each unit. These vectors are then used to simulate the results
of the first election. The smaller the value of this parameter,
the closer the unit-level marginal distributions for the first election
are to \code{prop1}. Default, \code{0.1}.}

\item{theta2}{Either a single number between 0 and 1 or a vector of length \code{nrow(TM)}
containing numbers between 0 and 1. The values in \code{theta2} serve as
overdispersion parameters and are used alongside the row-probability
vectors in \code{TM} within the underlying Dirichlet distributions.
These distributions are employed to generate probability vectors
for each combination of unit, cluster, and row, which are then used
to simulate vote transfers from the first to the second election.
If \code{theta2} is a vector, each row is assigned a distinct overdispersion
parameter based on its corresponding value. Default, \code{0.1}.}

\item{cs}{A positive number indicating the average number of cluster size. Default, \code{50}.}

\item{noise}{Either a single number between 0 and 1 or a vector of length \code{nrow(TM)}
containing numbers between 0 and 1. These numbers account for the
proportion of causal voters of each origin party (row).
These numbers are used to introduce more variability, compared
to the BPF model, into the simulations.
If \code{noise > 0}, a 100*noise percentage of votes of each row of each unit
are randomly assigned among the column parties.
Default, \code{0}.}

\item{simplify}{A TRUE/FALSE argument indicating whether the simulated RxCxK array of
counts by polling unit should be rearranged as a matrix of order Kx(RC).
Default, FALSE.}

\item{...}{Other arguments to be passed to the function. Not currently used.}
}
\value{
A list with the following components

\item{votes1}{ A matrix of order KxR with the results simulated in each polling unit for the first election.}
\item{votes2}{ A matrix of order KxC with the results simulated in each polling unit for the second election..}
\item{TM.global}{ A matrix of order RxC with the actual simulated global transfer matrix of counts.}
\item{TM.units}{ An array of order RxCxK with the simulated transfer matrices of votes by polling unit. If
\code{simplify = TRUE} the simulated transfer matrices of votes are returned organized in a Kx(RC) matrix.}
\item{inputs}{ A list containing all the objects with the values used as arguments by the function.}
}
\description{
Generates at random a set of RxC tables with the joint distribution of voters in two elections according to the model proposed in Forcina et al. (2012), as extension of Brown and Payne (1986), under the assumption that local units are homogeneous (no covariates). Results in the first election may be provided by the user or generated at random according to the overdispersed multinomial model.
}
\examples{
TMg <- matrix(c(0.6, 0.1, 0.3, 0.1, 0.7, 0.2, 0.1, 0.1, 0.8),
             byrow = TRUE, nrow = 3)
example <- simula_BPF(n.units = 100, TM = TMg, prop1 = c(0.3, 0.3, 0.4),
                      polling.sizes = c(750, 850))
}
\references{
Brown, P. and Payne, C. (1986). Aggregate data, ecological regression and voting transitions. \emph{Journal of the American Statistical Association}, 81, 453–460. \doi{10.1080/01621459.1986.10478290}

Forcina, A., Gnaldi, M. and Bracalente, B. (2012). A revised Brown and Payne model of voting behaviour applied to the 2009 elections in Italy. \emph{Statistical Methods & Applications}, 21, 109–119. \doi{10.1007/s10260-011-0184-x}
}
\seealso{
Other simulators for ecological inference overdispersed-multinomial models: 
\code{\link{simula_BPF_with_deviations}()}
}
\author{
Antonio Forcina, \email{forcinarosara@gmail.com}

Jose M. Pavia, \email{pavia@uv.es}
}
\concept{simulators for ecological inference overdispersed-multinomial models}
