## ----echo=FALSE, message=FALSE, warning=FALSE---------------------------------
# Ensure the temporary library from R CMD check is visible (esp. on Windows)
libdir <- Sys.getenv("R_LIBS")
if (nzchar(libdir)) {
  parts <- strsplit(libdir, .Platform$path.sep, fixed = TRUE)[[1]]
  .libPaths(unique(c(parts, .libPaths())))
}

# now load your package
suppressPackageStartupMessages(library(ecotourism))


## ----echo=TRUE, eval=TRUE, message=FALSE, warning=FALSE-----------------------
library(dplyr)
library(ecotourism)
data("gouldian_finch")
gouldian_finch |> glimpse()


## ----echo=TRUE, fig.width=6, fig.height=4, eval=TRUE--------------------------
library(ggplot2)
library(ggthemes)

gouldian_finch |> 
  ggplot() +
    geom_sf(data = oz_lga) +
    geom_point(aes(x = obs_lon, y = obs_lat), color = "red") +
    theme_map()


## ----echo=TRUE, fig.width=6, fig.height=4, eval=TRUE--------------------------
week_order <- c("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday")

gouldian_finch |> 
  ggplot(aes(x = factor(weekday, levels = week_order))) +
    geom_bar() +
    labs(x = "Weekday", y = "Number of Records") +
    theme_minimal()


## ----echo=TRUE, fig.width=6, fig.height=4, eval=TRUE, message=FALSE, warning=FALSE----
library(lubridate)

gouldian_finch |>
    dplyr::mutate(month = month(month, label = TRUE, abbr = TRUE)) |>
    ggplot(aes(x = factor(month))) +
    geom_bar() +
    labs(x = "Month", y = "Number of Records") +
    theme_minimal()


## ----echo=TRUE, fig.width=6, fig.height=4, eval=TRUE--------------------------
gouldian_finch |>
    ggplot(aes(x = factor(year))) +
    geom_bar() +
    labs(x = "Year", y = "Number of Records")+
    theme_minimal()


## ----echo=TRUE, eval=TRUE, message=FALSE, warning=FALSE, fig.width=6, fig.height=4----
library(ggbeeswarm)

# Prepare gouldian_finch occurrence counts per day
gouldian_finch_daily <- gouldian_finch |>
  group_by(ws_id, date) |>
  summarise(occurrence = n(), .groups = "drop")

# Join with weather data for precipitation
gouldian_finch_weather <- gouldian_finch_daily |>
  left_join(weather |> select(ws_id, date, prcp), 
            by = c("ws_id", "date"))

gouldian_finch_weather |>
  filter(!is.na(prcp)) |>
  mutate(rain = if_else(prcp > 5, "yes", "no")) |>
  ggplot(aes(x = rain, y = occurrence)) +
  geom_quasirandom(alpha = 0.6) +
  ylim(c(0, 15)) +
  labs(
    title = "Relationship between rainy day and gouldian finch occurrence",
    x = "Rainy",
    y = "Number of Gouldian Finch records"
  ) +
  theme_minimal()



## ----echo=TRUE, eval=TRUE, message=FALSE, warning=FALSE, fig.width=6, fig.height=4----

gouldian_finch_weather <- gouldian_finch_daily |> 
  left_join(
    weather |> select(ws_id, date, temp, prcp),
    by = c("ws_id", "date")
  )


ggplot(gouldian_finch_weather, aes(temp, occurrence, color = prcp)) +
  geom_point(alpha = 0.5) +
  scale_color_viridis_c() +
  labs(
    title = "Gouldian Finch occurrence vs temperature, colored by precipitation",
    x = "Mean daily temperature (°C)",
    y = "Occurrences",
    color = "Precipitation (mm)"
  ) +
  theme_minimal()



