% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge.EBM}
\alias{merge.EBM}
\title{Merge method for EBM objects}
\usage{
\method{merge}{EBM}(x, y, ...)
}
\arguments{
\item{x, y}{Fitted \link{ebm} objects that have been trained on similar data sets
that have the same set of features.}

\item{...}{Additional \link{ebm} objects to be merged.}
}
\value{
A merged \link{ebm} object.
}
\description{
Merge multiple EBMs together.
}
\note{
As of right now, the \code{merge()} function produces the following error
message:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Error in py_repr(x) :
  AttributeError: 'ExplainableBoostingRegressor' object has no attribute 'cat_smooth'
Run `reticulate::py_last_error()` for details.
}\if{html}{\out{</div>}}

This seems to be a bug in the underlying
\href{https://github.com/interpretml/interpret/}{interpret}
library and does not prevent this function from working. The error message is
seemingly just a side effect.
}
\examples{
\dontrun{
# Generate list of EBMs with different random seeds
ebms <- lapply(1:3, FUN = function(i) {
  ebm(mpg ~ ., data = mtcars, outer_bags = 1, random_state = i, obj = "rmse")
})

# Merge EBMs into one and plot term contribution for `cyl`
merged <- do.call(merge, args = ebms)
plot(merged, term = "cyl")
}


}
