% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cens_geo.R
\name{cens_geo}
\alias{cens_geo}
\title{Construct a Geography Specification for Census Data}
\usage{
cens_geo(geo = NULL, ..., check = TRUE, api = "acs/acs5", year = 2019)
}
\arguments{
\item{geo}{The geographic level to return. One of the machine-readable or
human-readable names listed in the "Details" section. Will return all
matching geographies of this level, as filtered by the further arguments to
\code{...}.  For example, setting \code{geo="tract"} is equivalent to setting
\code{tract="all"}.}

\item{...}{Geographies to return, as supported by the Census API. Order
matters here---the first argument will be the geographic level to return
(i.e., it corresponds to the \code{geo} argument) and additional arguments will
filter the results. Use \code{"all"}, \code{"*"}, \code{NA}, or \code{TRUE} to return all units
of a particular geography.  See the examples for details.}

\item{check}{If \code{TRUE}, validate the provided geographies against the
available geographies from the relevant Census API. Requires the \code{api} and
\code{year} arguments to be specified.}

\item{api}{A Census API programmatic name such as \code{"acs/acs5"}.}

\item{year}{The year for the data}
}
\value{
A list with two elements, \code{region} and \code{regionin}, which together
specify a valid Census API geography argument.
}
\description{
Currently used mostly internally.
Builds a Census API-formatted specification of which geographies to download
data for. State and county names (or postal abbreviations) are partially
matched to existing tables, for ease of use. Other geographies should be
specified with Census GEOIDs. The \code{usgazeteer} package, available with
\code{remotes::install_github("bhaskarvk/usgazetteer")}, may be useful in finding
GEOIDs for other geographies. Consult the "geography" sections of each API
at \url{https://www.census.gov/data/developers/data-sets.html} for information on
which geographic specifiers may be provided in combination with others.
}
\details{
Supported geography arguments:
\itemize{
\item \code{us}
\item \code{region}
\item \code{division}
\item \code{state}
\item \code{county}
\item \code{county_subdiv} (County Subdivision)
\item \code{subminor_civil_division} (Subminor Civil Division)
\item \code{place_remainder} (Place/Remainder (Or Part))
\item \code{tract_part} (Tract (Or Part))
\item \code{urban_rural} (Urban Rural)
\item \code{block_group_part} (Block Group (Or Part))
\item \code{block}
\item \code{tract}
\item \code{aian_area_part} (American Indian Area/Alaska Native Area/Hawaiian Home Land (Or Part))
\item \code{block_group} (Block Group)
\item \code{county_part} (County (Or Part))
\item \code{place_part} (Place (Or Part))
\item \code{place}
\item \code{consolidated_city} (Consolidated City)
\item \code{alaska_native_regional_corporation} (Alaska Native Regional Corporation)
\item \code{aian_area} (American Indian Area/Alaska Native Area/Hawaiian Home Land)
\item \code{tribal_subdiv} (Tribal Subdivision/Remainder)
\item \code{aian_reserve_stat} (American Indian Area/Alaska Native Area (Reservation Or Statistical Entity Only))
\item \code{ai_tribal_subdiv_part} (American Indian Tribal Subdivision (Or Part))
\item \code{ai_off_reserve_trust} (American Indian Area (Off-Reservation Trust Land Only)/Hawaiian Home Land)
\item \code{tribal_census_tract} (Tribal Census Tract)
\item \code{tribal_census_tract_part} (Tribal Census Tract (Or Part))
\item \code{tribal_block_group} (Tribal Block Group)
\item \code{state_part} (State (Or Part))
\item \code{county_subdiv_part} (County Subdivision (Or Part))
\item \code{tribal_subdiv_part} (Tribal Subdivision/Remainder (Or Part))
\item \code{aian_reserve_stat_part} (American Indian Area/Alaska Native Area (Reservation Or Statistical Entity Only) (Or Part))
\item \code{ai_off_reserve_trust_part} (American Indian Area (Off-Reservation Trust Land Only)/Hawaiian Home Land (Or Part))
\item \code{tribal_block_group_part} (Tribal Block Group (Or Part))
\item \code{msa} (Metropolitan Statistical Area/Micropolitan Statistical Area)
\item \code{principal_city_part} (Principal City (Or Part))
\item \code{metro_division} (Metropolitan Division)
\item \code{msa_part} (Metropolitan Statistical Area/Micropolitan Statistical Area (Or Part))
\item \code{metro_division_part} (Metropolitan Division (Or Part))
\item \code{combined_statistical_area} (Combined Statistical Area)
\item \code{combined_necta} (Combined New England City And Town Area)
\item \code{necta} (New England City And Town Area)
\item \code{combined_statistical_area_part} (Combined Statistical Area (Or Part))
\item \code{combined_necta_part} (Combined New England City And Town Area (Or Part))
\item \code{necta_part} (New England City And Town Area (Or Part))
\item \code{principal_city} (Principal City)
\item \code{necta_division} (Necta Division)
\item \code{necta_division_part} (Necta Division (Or Part))
\item \code{urban_area} (Urban Area)
\item \code{urban_area_part} (Urban Area (Or Part))
\item \code{consolidated_city_part} (Consolidated City (Or Part))
\item \code{cd} (Congressional District)
\item \code{sld_upper} (State Legislative District (Upper Chamber))
\item \code{sld_lower} (State Legislative District (Lower Chamber))
\item \code{alaska_native_regional_corporation_part} (Alaska Native Regional Corporation (Or Part))
\item \code{zcta} (Zip Code Tabulation Area)
\item \code{zcta_part} (Zip Code Tabulation Area (Or Part))
\item \code{school_district_elementary} (School District (Elementary))
\item \code{school_district_secondary} (School District (Secondary))
\item \code{school_district_unified} (School District (Unified))
\item \code{congressional_district_part} (Congressional District (Or Part))
\item \code{school_district_elementary_part} (School District (Elementary) (Or Part))
\item \code{school_district_secondary_part} (School District (Secondary) (Or Part))
\item \code{school_district_unified_part} (School District (Unified) (Or Part))
\item \code{voting_district_part} (Voting District (Or Part))
\item \code{subminor_civil_division_part} (Subminor Civil Division (Or Part))
\item \code{state_legislative_district_upper_chamber_part} (State Legislative District (Upper Chamber) (Or Part))
\item \code{state_legislative_district_lower_chamber_part} (State Legislative District (Lower Chamber) (Or Part))
\item \code{vtd} (Voting District)
\item \code{ai_tribal_subdiv} (American Indian Tribal Subdivision)
\item \code{puma} (Public Use Microdata Area)
}
}
\examples{
cens_geo(state="WA")
cens_geo("county", state="WA") # equivalent to `cens_geo(county="all", state="WA")`
cens_geo(county="King", state="Wash")
cens_geo(zcta="02138", check=FALSE)
cens_geo(zcta=NA, state="WA", check=FALSE)
cens_geo("zcta", state="WA", check=FALSE)
cens_geo(cd="09", state="WA", check=FALSE)
cens_geo("county_part", state="WA", cd="09", check=FALSE)

}
