% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easybgm_compare.R
\name{easybgm_compare}
\alias{easybgm_compare}
\title{Compare networks across groups using Bayesian inference}
\usage{
easybgm_compare(
  data,
  type,
  package = NULL,
  not_cont = NULL,
  group_indicator = NULL,
  iter = 10000,
  save = TRUE,
  progress = TRUE,
  ...
)
}
\arguments{
\item{data}{A list with two n x p matrices or dataframes containing the variables for n independent observations on
p variables for two groups. Note that the variables need to be the same in the two different dataframes. Alternatively,
when "bgms" version > 0.1.6 is installed, 'data' can also be a matrix of binary and ordinal responses from all groups.
If this is the case, the 'group_indicator' argument also needs to be specified.}

\item{type}{What is the data type? Options: continuous, mixed, ordinal, binary, or blume-capel.}

\item{package}{The R-package that should be used for fitting the network model; supports BGGM and bgms. Optional argument;
default values are specified depending on the datatype.}

\item{not_cont}{If data-type is mixed, a vector of length p, specifying the not-continuous
variables (1 = not continuous, 0 = continuous).}

\item{group_indicator}{Optional integer vector of group memberships for the rows of the dataframe (multi-group comparison),
when data is a matrix instead of a list of two dataframes.}

\item{iter}{number of iterations for the sampler. Default is 1e4.}

\item{save}{Logical. Should the posterior samples be obtained (default = TRUE)?}

\item{progress}{Logical. Should a progress bar be shown (default = TRUE)?}

\item{...}{Additional arguments that are handed to the fitting functions of the packages, e.g., informed prior specifications.}
}
\value{
The returned object of \code{easybgm} contains several elements:

\itemize{

\item \code{parameters} A p x p matrix containing difference across partial associations.

\item \code{inc_probs} A p x p matrix containing the posterior inclusion probabilities of subgroup differences.

\item \code{inc_BF} A p x p matrix containing the posterior inclusion Bayes factors of subgroup differences.

\item \code{structure} Adjacency matrix of the median probability model (i.e., edges with a posterior probability larger 0.5).
}

In addition, for \code{bgms}, the function returns:

\itemize{

\item \code{structure_probabilities} A vector containing the posterior probabilities of all visited structures, between 0 and 1.

\item \code{graph_weights} A vector containing the number of times a particular structure was visited.

\item \code{sample_graph} A vector containing the indexes of a particular structure.

\item \code{convergence_parameter} A vector containing the R-hat (Gelman–Rubin) statistic for the difference parameter measuring how well MCMC chains have converged to the same target distribution.
}

For both packages, when setting \code{save = TRUE}, the function will also return the following object:

\itemize{

\item \code{samples_posterior} A k x iter matrix containing the posterior samples of parameter differences (i.e., k = (p/(p-1))/2) at each iteration (i.e., iter) of the sampler.
}
}
\description{
Easy comparison of networks using Bayesian inference to extract differences in conditional (in)dependence across groups.
}
\details{
Users may oftentimes wish to deviate from the default, usually uninformative, prior specifications of the
packages to informed priors. This can be done by simply adding additional arguments to the \code{easybgm} function.
Depending on the package that is running the underlying network estimation, researcher can specify different prior
arguments. Please consult the original packages "bgms" and "BGGM" for the specific informed prior options.

We always encourage researcher to conduct prior robustness checks.
}
\examples{

\donttest{
library(easybgm)
library(bgms)

data <- na.omit(ADHD)

group1 <- data[1:10, 1:3]
group2 <- data[11:20, 1:3]

# Fitting the Wenchuan PTSD data

fit <- easybgm_compare(list(group1, group2), 
                type = "binary", save = TRUE,
                iter = 50 # for demonstration only (> 5e4 recommended)
                )

summary(fit)

# For multigroup estimation
fit_multi <- easybgm_compare(data[1:200, 1:5], 
                group_indicator = rep(c(1, 2, 3, 4), each = 50),
                type = "binary", save = TRUE, 
                iter = 100 # for demonstration only (> 5e4 recommended)
                )

summary(fit_multi)
}
}
