% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_surrogate_fx.R
\name{get_pubmed_ids}
\alias{get_pubmed_ids}
\title{Simple PubMed Record Search}
\usage{
get_pubmed_ids(pubmed_query_string, api_key = NULL)
}
\arguments{
\item{pubmed_query_string}{String (character vector of length 1), 
corresponding to the query string used for querying PubMed.}

\item{api_key}{String (character vector of length 1), 
corresponding to the NCBI API key. Can be NULL.}
}
\value{
An easyPubMed object which includes no PubMed records.
}
\description{
Query PubMed (Entrez) in a simple way via the PubMed API eSearch function. 
Calling this function results in posting the query results on the PubMed 
History Server. This allows later access to the resulting data via the 
fetch_pubmed_data() function, or other easyPubMed functions. 
NOTE: this function has become obsolete. You should use the epm_query() 
function instead. Please, have a look at the manual or the vignette.
The \code{get_pubmed_ids()} function will be retired in 2026.
}
\details{
This function will use the String provided as argument for 
querying PubMed via the eSearch function of the PubMed API. 
The Query Term can include one or multiple words, as well as the 
standard PubMed operators (AND, OR, NOT) and 
tags (i.e., [AU], [PDAT], [Affiliation], and so on). ESearch will post 
the UIDs resulting from the search operation onto the History server 
so that they can be used directly in a subsequent fetchPubmedData() call.
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  qry <- 'Damiano Fantini[AU] AND "2018"[PDAT]'
  get_pubmed_ids(pubmed_query_string = qry)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)



}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
