% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_date_parse}
\alias{EPM_date_parse}
\title{Parse and Format a Pubmed Date Field.}
\usage{
EPM_date_parse(x)
}
\arguments{
\item{x}{String (character vector of length 1) including an XML date
field from a PubMed record.}
}
\value{
list including n=3 numeric elements: day, month and year.
}
\description{
Extract Date Information form a slice of a raw XML PubMed record. 
Day, month and year are returned. Months are recoded as numeric
if needed (e.g., `Oct` and `October` are converted to 10). If
month and/or day information are missing, these are imputed to 1.
If the year is missing, NA is returned.
}
\examples{
dt0 <- '<Year>2021</Year><Month>03</Month><Day>12</Day>'
easyPubMed:::EPM_date_parse(dt0)



}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
