% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stac-collections_fetch.R
\name{collections_fetch}
\alias{collections_fetch}
\title{Fetch all collections from an \code{\link[rstac:collections]{rstac::collections()}} query}
\usage{
collections_fetch(collections, ...)
}
\arguments{
\item{collections}{an object of class \code{doc_collections} as returned
by calling \code{\link[rstac:request]{rstac::get_request()}} on an \code{\link[rstac:collections]{rstac::collections()}} query}

\item{...}{Optional arguments passed on to \code{\link[httr:GET]{httr::GET()}}}
}
\value{
A \code{doc_collections} object with all of the collections from the catalogue
specified in the \code{\link[rstac:collections]{rstac::collections()}} query.
}
\description{
By default, NASA STAC catalogue collections queries only return
10 collections at a time. This function will page through
the collections and return them all.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

 rstac::stac("https://cmr.earthdata.nasa.gov/stac/LPCLOUD") |> 
   rstac::collections() |> 
   rstac::get_request() |> 
   collections_fetch()
\dontshow{\}) # examplesIf}
}
