% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_variables.R
\name{combine_variables}
\alias{combine_variables}
\title{Compute Weighted Combined Score from Multiple ariables}
\usage{
combine_variables(formula, data, weights = NULL)
}
\arguments{
\item{formula}{A formula specifying the ariables, e.g., `1 ~ cov1 + cov2 + cov3`.
The left side should be 1 (placeholder).}

\item{data}{A data frame containing the variables specified in the formula.}

\item{weights}{A numeric vector of relative importance weights for each variable.
Must have the same length as the number of variables in the formula.
Higher weights indicate greater contribution (correlation) to the combined score.
If NULL, equal weights (all 1s) are used. Default: NULL.}
}
\value{
A numeric vector of the same length as nrow(data), representing the combined
        weighted score for each observation. The score correlates with each input
        variable proportionally to its importance weight.
}
\description{
Creates a single combined variable from multiple ariables,
weighted by relative importance scores. Variables are scaled before combination.
}
\details{
Variables are first scaled to mean 0 and standard deviation 1, then
         multiplied by their importance weights and summed. The final score is
         a weighted linear combination: score = w1*z1 + w2*z2 + ... + wk*zk,
         where zi are the scaled variables and wi are the weights.
}
\examples{
dat <- data.frame(
  age    = rnorm(80, 5, 2),
  weight = rnorm(80, 11, 2),
  class  = rbinom(80, 3, 0.5)
)

# Equal weights
score <- combine_variables(1 ~ age + weight + class, data = dat)

# Custom weights: age contributes 2x, weight 1.5x, class 1x
score <- combine_variables(1 ~ age + weight + class, data = dat,
                           weights = c(2, 1.5, 1))

}
