% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputUniConstructComp.R
\name{outputUniConstructComp}
\alias{outputUniConstructComp}
\title{A Function That Fits and Compares Competing Dyadic Uni-construct Models}
\usage{
outputUniConstructComp(
  dvn,
  dat,
  indexes = c("df", "chisq", "cfi", "rmsea", "bic", "GenTEFI"),
  ...,
  gtTab = FALSE,
  writeTo = NULL,
  fileName = NULL
)
}
\arguments{
\item{dvn}{Input dvn list from \code{scrapeVarCross()}.}

\item{dat}{Input data frame containing the dataset for model estimation.}

\item{indexes}{Input character vector specifying which index(es) to return.
Default is \code{c("df", "chisq", "cfi", "rmsea", "bic", "GenTEFI")}.
\strong{Note}:
\itemize{
\item Valid entries include "GenTEFI"---the Generalized Total Entropy Fit Index
(see Golino et al., 2024)---and those from \code{lavaan::fitMeasures()}.
\item If "chisq" is entered, chi-squared difference tests are automatically performed via
\code{lavaan::lavTestLRT()}, and the resulting p-values are added to the output.
}}

\item{...}{Additional arguments to be passed to \code{lavaan::cfa()}, allowing
users to customize model estimation settings. By default, the models are
fit with maximum-likelihood estimation (\code{estimator = "ml"}) and missing
data are handled via listwise deletion (\code{missing = "listwise"}), as per
\code{lavaan::cfa()}'s default behaviour.}

\item{gtTab}{A logical input indicating whether to generate the requested
index(es) for each fitted model (requested via the \code{indexes} argument) in
\code{gt::gt()} table object format (\code{TRUE}). Users can also apply the \code{writeTo}
argument if they wish to export the \code{gt::gt()} table object.}

\item{writeTo}{A character vector string specifying a directory path to where
the \code{gt::gt()} table object should be saved. If set to ".", the file will be
written to the current working directory. The default is \code{NULL}, and examples
use a temporary directory created by \code{tempdir()}. \code{writeTo} is only relevant
if \code{gtTab = TRUE}.}

\item{fileName}{A character string specifying a desired base name for the output
\code{gt::gt()} file. The resulting base name will automatically be appended with a
\code{.rtf} file extension. \code{fileName} is only relevant if \code{gtTab = TRUE} and \code{writeTo}
is specified.}
}
\value{
A \code{list} containing up to two components:
\itemize{
\item \code{Indexes}: A \code{tibble::tibble()} if \code{gtTab = FALSE} (default), or \code{gt::gt()}
object if \code{gtTab = TRUE}, with the desired index(es) for each fitted model
(requested via the \code{indexes} argument).
\item \code{GenTEFI}: A \code{tibble::tibble()} of the GenTEFI (if "GenTEFI" is included in
the \code{indexes} argument).
}
}
\description{
This function takes the outputted object from \code{scrapeVarCross()}
along with the corresponding dataset and automatically tests competing
uni-construct dyadic models for the latent variable under consideration.
It inspects four possible model variants:
\itemize{
\item Bifactor (scripted via \code{dySEM::scriptBifac})
\item Hierarchical (scripted via \code{dySEM::scriptHier})
\item Correlated Factors (scripted via \code{dySEM::scriptCor})
\item Unidimensional (scripted via \code{dySEM::scriptUni})
}
}
\details{
\itemize{
\item If "chisq" is included in \code{indexes}, the specific form of the applied
chi-squared difference test (e.g., standard vs. robust) is determined
automatically by \code{lavaan::lavTestLRT()}, based on the model estimation
method used.
\item If \code{gtTab = TRUE} and \code{writeTo} is specified, then output will simultaneously
be saved as a \code{.rtf} file to the user's specified directory.
\item If output file is successfully saved, a confirmation message will be printed
to the console.
\item If a file with the same name already exists in the user's chosen directory,
it will be overwritten.
}
}
\examples{
dvn <- scrapeVarCross(
commitmentM,
x_order = "sip",
x_stem = "sat.g",
x_delim1 = "",
x_delim2 = "_",
distinguish_1 = "f",
distinguish_2 = "m"
)

# Quick example for CRAN checks
outputUniConstructComp(
  dvn,
  commitmentM,
  indexes = c("df", "bic"),
  missing = "listwise"
)

\donttest{
# More comprehensive examples (slower due to FIML estimation)
outputUniConstructComp(
  dvn,
  commitmentM,
  missing = "fiml"
)

outputUniConstructComp(
  dvn,
  commitmentM,
  indexes = c("df", "bic"),
  missing = "fiml"
)

outputUniConstructComp(
  dvn,
  commitmentM,
  indexes = c("df", "bic"),
  estimator = "ml",
  missing = "fiml"
)

outputUniConstructComp(
  dvn,
  commitmentM,
  indexes = c("df", "bic"),
  missing = "fiml",
  gtTab = TRUE,
  writeTo = tempdir(),
  fileName = "uni-construct-dyad-models"
)
}

}
