% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_combine.R
\name{ddbs_union}
\alias{ddbs_union}
\title{Union of geometries}
\usage{
ddbs_union(
  x,
  y = NULL,
  by = NULL,
  conn = NULL,
  name = NULL,
  crs = NULL,
  crs_column = "crs_duckspatial",
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{x}{An \code{sf} spatial object. Alternatively, it can be a string with the
name of a table with geometry column within the DuckDB database \code{conn}.
Data is returned from this object.}

\item{y}{optional. A second table name, \code{sf} object, or DuckDB connection
to compute the pairwise union between geometries in \code{x} and \code{y}.
Default is \code{NULL}}

\item{by}{optional. Character vector specifying one or more column names to
group by when computing unions. Geometries will be unioned within each group.
Default is \code{NULL}}

\item{conn}{A connection object to a DuckDB database. If \code{NULL}, the function
runs on a temporary DuckDB database.}

\item{name}{A character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table
names. If \code{NULL} (the default), the function returns the result as an
\code{sf} object}

\item{crs}{The coordinates reference system of the data. Specify if the data
doesn't have a \code{crs_column}, and you know the CRS.}

\item{crs_column}{character string specifying the name of the CRS column.
Default is \code{"crs_duckspatial"}}

\item{overwrite}{Boolean. whether to overwrite the existing table if it exists. Defaults
to \code{FALSE}. This argument is ignored when \code{name} is \code{NULL}.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
an \code{sf} object or \code{TRUE} (invisibly) for table creation
}
\description{
Computes the union of geometries from a \code{sf} objects or a DuckDB tables using.
This is equivalent to \code{sf::st_union()}. The function supports three modes:
(1) union all geometries from a single object into one geometry,
(2) union geometries from a single object grouped by one or more columns,
(3) union geometries from two different objects.
Returns the result as an \code{sf} object or creates a new table in the database.
}
\examples{
\dontrun{
# load packages
library(duckspatial)
library(sf)

# create a duckdb database in memory (with spatial extension)
conn <- ddbs_create_conn(dbdir = "memory")

# read data
rivers_sf <- st_read(system.file("spatial/rivers.geojson", package = "duckspatial"))

# store in duckdb
ddbs_write_vector(conn, rivers_sf, "rivers")

# union all geometries into one
ddbs_union(conn = conn, "rivers")

# union without using a connection
ddbs_union(rivers_sf)

# union geometries grouped by a column
ddbs_union(conn = conn, "rivers", by = "RIVER_NAME")

# store result in a new table
ddbs_union(conn = conn, "rivers", name = "rivers_union")
}
}
