% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_affine.R
\name{ddbs_rotate}
\alias{ddbs_rotate}
\title{Rotate geometries around centroid}
\usage{
ddbs_rotate(
  x,
  angle,
  units = c("degrees", "radians"),
  by_feature = FALSE,
  center_x = NULL,
  center_y = NULL,
  conn = NULL,
  name = NULL,
  crs = NULL,
  crs_column = "crs_duckspatial",
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{x}{An \code{sf} spatial object. Alternatively, it can be a string with the
name of a table with geometry column within the DuckDB database \code{conn}.
Data is returned from this object.}

\item{angle}{a numeric value specifying the rotation angle}

\item{units}{character string specifying angle units: "degrees" (default) or "radians"}

\item{by_feature}{Logical. If \code{TRUE}, the geometric operation is applied
separately to each geometry. If \code{FALSE} (default), the geometric
operation is applied to the data as a whole.}

\item{center_x}{numeric value for the X coordinate of rotation center. If NULL,
rotates around the centroid of each geometry}

\item{center_y}{numeric value for the Y coordinate of rotation center. If NULL,
rotates around the centroid of each geometry}

\item{conn}{A connection object to a DuckDB database. If \code{NULL}, the function
runs on a temporary DuckDB database.}

\item{name}{A character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table
names. If \code{NULL} (the default), the function returns the result as an
\code{sf} object}

\item{crs}{The coordinates reference system of the data. Specify if the data
doesn't have a \code{crs_column}, and you know the CRS.}

\item{crs_column}{a character string of length one specifying the column
storing the CRS (created automatically by \code{\link{ddbs_write_vector}}).
Set to \code{NULL} if absent.}

\item{overwrite}{Boolean. whether to overwrite the existing table if it exists. Defaults
to \code{FALSE}. This argument is ignored when \code{name} is \code{NULL}.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
an \code{sf} object or \code{TRUE} (invisibly) for table creation
}
\description{
Rotates geometries from from a \code{sf} object or a DuckDB table. Returns the
result as an \code{sf} object or creates a new table in the database.
}
\examples{
\dontrun{
## load packages
library(duckspatial)
library(sf)

# create a duckdb database in memory (with spatial extension)
conn <- ddbs_create_conn(dbdir = "memory")

## read data
argentina_sf <- st_read(system.file("spatial/argentina.geojson", package = "duckspatial"))

## store in duckdb
ddbs_write_vector(conn, argentina_sf, "argentina")

## rotate 45 degrees
ddbs_rotate(conn = conn, "argentina", angle = 45)

## rotate 90 degrees around a specific point
ddbs_rotate(conn = conn, "argentina", angle = 90, center_x = -64, center_y = -34)

## rotate without using a connection
ddbs_rotate(argentina_sf, angle = 45)
}
}
