% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{unnest.trackr_df}
\alias{unnest.trackr_df}
\title{Reshaping data using \code{tidyr::unnest}}
\usage{
\method{unnest}{trackr_df}(
  data,
  cols,
  ...,
  keep_empty = FALSE,
  ptype = NULL,
  names_sep = NULL,
  names_repair = "check_unique",
  .drop = deprecated(),
  .id = deprecated(),
  .sep = deprecated(),
  .preserve = deprecated(),
  .messages = "",
  .headline = ""
)
}
\arguments{
\item{data}{A data frame.}

\item{cols}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> List-columns to unnest.

When selecting multiple columns, values from the same row will be recycled
to their common size.}

\item{...}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
previously you could write \code{df \%>\% unnest(x, y, z)}.
Convert to \code{df \%>\% unnest(c(x, y, z))}. If you previously created a new
variable in \code{unnest()} you'll now need to do it explicitly with \code{mutate()}.
Convert \code{df \%>\% unnest(y = fun(x, y, z))}
to \code{df \%>\% mutate(y = fun(x, y, z)) \%>\% unnest(y)}.}

\item{keep_empty}{By default, you get one row of output for each element
of the list that you are unchopping/unnesting. This means that if there's a
size-0 element (like \code{NULL} or an empty data frame or vector), then that
entire row will be dropped from the output. If you want to preserve all
rows, use \code{keep_empty = TRUE} to replace size-0 elements with a single row
of missing values.}

\item{ptype}{Optionally, a named list of column name-prototype pairs to
coerce \code{cols} to, overriding the default that will be guessed from
combining the individual values. Alternatively, a single empty ptype
can be supplied, which will be applied to all \code{cols}.}

\item{names_sep}{If \code{NULL}, the default, the outer names will come from the
inner names. If a string, the outer names will be formed by pasting
together the outer and the inner column names, separated by \code{names_sep}.}

\item{names_repair}{Used to check that output data frame has valid
names. Must be one of the following options:
\itemize{
\item \verb{"minimal}": no name repair or checks, beyond basic existence,
\item \verb{"unique}": make sure names are unique and not empty,
\item \verb{"check_unique}": (the default), no name repair, but check they are unique,
\item \verb{"universal}": make the names unique and syntactic
\item a function: apply custom name repair.
\item \link[tidyr]{tidyr_legacy}: use the name repair from tidyr 0.8.
\item a formula: a purrr-style anonymous function (see \code{\link[rlang:as_function]{rlang::as_function()}})
}

See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for more details on these terms and the
strategies used to enforce them.}

\item{.drop, .preserve}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
all list-columns are now preserved; If there are any that you
don't want in the output use \code{select()} to remove them prior to
unnesting.}

\item{.id}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
convert \code{df \%>\% unnest(x, .id = "id")} to \verb{df \%>\% mutate(id = names(x)) \%>\% unnest(x))}.}

\item{.sep}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
use \code{names_sep} instead.}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, grouping variable, \{.count.in\}, \{.count.out\} or \{.strata\}.
Defaults to nothing. Older versions of \code{tidyr::unnest} can throw an error
if this is more than 1 item long and and in that case use the \code{dtrackr}
specific \code{p_nest} will work instead.}

\item{.headline}{a headline glue spec. The glue code can use any global
variable, grouping variable, or \{.strata\}. Defaults to nothing.}
}
\value{
the result of the \code{tidyr::unnest} but with a history graph
updated.
}
\description{
A drop in replacement for \code{\link[tidyr:unnest]{tidyr::unnest()}} which optionally takes a message
and headline to store in the history graph. Older versions of \code{tidyr::unnest}
can throw an error if \code{.messages} is more than 1 item long and in that case
use the \code{dtrackr} specific \code{p_unnest} will work instead.
}
\examples{
library(dplyr)
library(dtrackr)

starwars \%>\%
  track() \%>\%
  tidyr::unnest(starships, keep_empty = TRUE) \%>\%
  tidyr::nest(world_data = c(-homeworld)) \%>\%
  history()

# There is a problem with `tidyr::unnest` that means if you want to override the
# `.messages` option at the moment it will most likely fail. Forcing the use of
# the specific `dtrackr::p_unnest` version solves this problem, until hopefully it is
# resolved in `tidyr`:
starwars \%>\%
  track() \%>\%
  p_unnest(
    films,
    .messages = c("{.count.in} characters", "{.count.out} appearances")
  ) \%>\%
  dplyr::group_by(gender) \%>\%
  tidyr::nest(
    people = c(-gender, -species, -homeworld),
    .messages = c("{.count.in} appearances", "{.count.out} planets")
  ) \%>\%
  status() \%>\%
  history()

# This example includes pivoting and nesting. The CMS patient care data
# has multiple tests per institution in a long format, and observed /
# denominator types. Firstly we pivot the data to allow us to easily calculate
# a total percentage for each institution. This is duplicated for every test
# so we nest the tests to get to one row per institution. Those institutions
# with invalid scores are excluded.
cms_history = tidyr::cms_patient_care \%>\%
  track() \%>\%
  tidyr::pivot_wider(names_from = type, values_from = score) \%>\%
  dplyr::mutate(
    percentage = sum(observed) / sum(denominator) * 100,
    .by = c(ccn, facility_name)
  ) \%>\%
  tidyr::nest(
    results = c(measure_abbr, observed, denominator),
    .messages = c("{.count.in} test results", "{.count.out} facilities")
  ) \%>\%
  exclude_all(
    percentage > 100 ~ "{.excluded} facilities with anomalous percentages",
    na.rm = TRUE
  )

print(cms_history \%>\% dtrackr::history())

# not run in examples:
if (interactive()) {
  cms_history \%>\% flowchart()
}
}
\seealso{
\code{\link[tidyr:unnest]{tidyr::unnest()}}
}
