% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{add_count.trackr_df}
\alias{add_count.trackr_df}
\title{dplyr modifying operations}
\usage{
\method{add_count}{trackr_df}(x, ..., .messages = "", .headline = "", .tag = NULL)

\method{add_count}{trackr_df}(x, ..., .messages = "", .headline = "", .tag = NULL)
}
\arguments{
\item{x}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr).}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables to group
by.
  Named arguments passed on to \code{\link[dplyr:count]{dplyr::add_count}}\describe{
    \item{\code{wt}}{<\code{\link[rlang:args_data_masking]{data-masking}}> Frequency weights.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}
\item{\code{sort}}{If \code{TRUE}, will show the largest groups at the top.}
\item{\code{name}}{The name of the new column in the output.

If omitted, it will default to \code{n}. If there's already a column called \code{n},
it will use \code{nn}. If there's a column called \code{n} and \code{nn}, it'll use
\code{nnn}, and so on, adding \code{n}s until it gets a new name.}
\item{\code{.drop}}{Handling of factor levels that don't appear in the data, passed
on to \code{\link[dplyr:group_by]{group_by()}}.

For \code{count()}: if \code{FALSE} will include counts for empty groups (i.e. for
levels of factors that don't exist in the data).

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} For \code{add_count()}: deprecated since it
can't actually affect the output.}
}
  Named arguments passed on to \code{\link[tidyr:unnest]{tidyr::unnest}}\describe{
    \item{\code{data}}{A data frame.}
\item{\code{cols}}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> List-columns to unnest.

When selecting multiple columns, values from the same row will be recycled
to their common size.}
\item{\code{keep_empty}}{By default, you get one row of output for each element
of the list that you are unchopping/unnesting. This means that if there's a
size-0 element (like \code{NULL} or an empty data frame or vector), then that
entire row will be dropped from the output. If you want to preserve all
rows, use \code{keep_empty = TRUE} to replace size-0 elements with a single row
of missing values.}
\item{\code{ptype}}{Optionally, a named list of column name-prototype pairs to
coerce \code{cols} to, overriding the default that will be guessed from
combining the individual values. Alternatively, a single empty ptype
can be supplied, which will be applied to all \code{cols}.}
\item{\code{names_sep}}{If \code{NULL}, the default, the outer names will come from the
inner names. If a string, the outer names will be formed by pasting
together the outer and the inner column names, separated by \code{names_sep}.}
\item{\code{names_repair}}{Used to check that output data frame has valid
names. Must be one of the following options:
\itemize{
\item \verb{"minimal}": no name repair or checks, beyond basic existence,
\item \verb{"unique}": make sure names are unique and not empty,
\item \verb{"check_unique}": (the default), no name repair, but check they are unique,
\item \verb{"universal}": make the names unique and syntactic
\item a function: apply custom name repair.
\item \link[tidyr]{tidyr_legacy}: use the name repair from tidyr 0.8.
\item a formula: a purrr-style anonymous function (see \code{\link[rlang:as_function]{rlang::as_function()}})
}

See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for more details on these terms and the
strategies used to enforce them.}
\item{\code{.drop,.preserve}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
all list-columns are now preserved; If there are any that you
don't want in the output use \code{select()} to remove them prior to
unnesting.}
\item{\code{.id}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
convert \code{df \%>\% unnest(x, .id = "id")} to \verb{df \%>\% mutate(id = names(x)) \%>\% unnest(x))}.}
\item{\code{.sep}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
use \code{names_sep} instead.}
}}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, grouping variable, \{.new_cols\} or \{.dropped_cols\} for changes to
columns, \{.cols\} for the output column names, or \{.strata\}. Defaults to nothing.}

\item{.headline}{a headline glue spec. The glue code can use any global
variable, grouping variable, \{.new_cols\}, \{.dropped_cols\}, \{.cols\} or \{.strata\}.
Defaults to nothing.}

\item{.tag}{if you want the summary data from this step in the future then
give it a name with .tag.}
}
\value{
the \code{.data} dataframe after being modified by the \code{dplyr} equivalent
function, but with the history graph updated with a new stage if the
\code{.messages} or \code{.headline} parameter is not empty.
}
\description{
See \code{\link[dplyr:mutate]{dplyr::mutate()}}, \code{\link[dplyr:count]{dplyr::add_count()}}, \code{\link[dplyr:count]{dplyr::add_tally()}},
\code{\link[dplyr:transmute]{dplyr::transmute()}}, \code{\link[dplyr:select]{dplyr::select()}}, \code{\link[dplyr:relocate]{dplyr::relocate()}},
\code{\link[dplyr:rename]{dplyr::rename()}} \code{\link[dplyr:rename]{dplyr::rename_with()}}, \code{\link[dplyr:arrange]{dplyr::arrange()}} for more details
on underlying functions. \code{dtrackr} provides equivalent functions for
mutating, selecting and renaming a data set which act in the same way as
\code{dplyr}. \code{mutate} / \code{select} / \code{rename} generally don't add anything in terms
of provenance of data so the default behaviour is to miss these out of the
\code{dtrackr} history. This can be overridden with the \code{.messages}, or
\code{.headline} values in which case they behave just like a \code{comment()}.
}
\examples{
library(dplyr)
library(dtrackr)

# mutate and other functions are unitary operations that generally change
# the structure but not size of a dataframe. In dtrackr these are by ignored
# by default but we can change that so that their behaviour is obvious.

# add_count
# adding in a count or tally column as a new column
iris \%>\%
  track() \%>\%
  add_count(Species, name="new_count_total",
            .messages="{.new_cols}",
            # .messages="{.cols}",
            .headline="New columns from add_count:") \%>\%
  history()

# add_tally
iris \%>\%
  track() \%>\%
  group_by(Species) \%>\%
  dtrackr::add_tally(wt=Petal.Length, name="new_tally_total",
            .messages="{.new_cols}",
            .headline="New columns from add_tally:") \%>\%
  history()



}
\seealso{
\code{\link[dplyr:count]{dplyr::add_count()}}
}
