% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtlcor_fun.R
\name{dtl_tier_sim}
\alias{dtl_tier_sim}
\title{Simulated family-wise type I error rate (FWER) given a fixed
correlation coefficient under drop-the-losers (DTL) design}
\usage{
dtl_tier_sim(nsim, n, t, rho, q, alpha_s, sel_g_func = sel_g_func_default, ...)
}
\arguments{
\item{nsim}{Number of replicates}

\item{n}{Sample size per arm at DTL look}

\item{t}{A vector of information fraction of final stage}

\item{rho}{Fixed correlation coefficient}

\item{q}{Response rate under the null}

\item{alpha_s}{Significance level for the final stage}

\item{sel_g_func}{Arm-select function. The default function is
sel_g_func_default(W_2, W_1, delta). Users can define
their own arm-select function. The format of
the function must be function_name(W_2, W_1, ...). The
return values must be 1 (arm 1 is selected) or 2 (arm 2
is selected) or 0 (stop for futility).}

\item{...}{Other arguments from sel_g_func.}
}
\value{
Simulated FWER alpha
}
\description{
Get the simulated FWER alpha given fixed correlation coefficient
}
\examples{
\donttest{
# Without interim analysis
dtl_tier_sim(nsim = 1000, n = 80, t = 1, rho = 0.4, q = 0.3, 
             alpha_s = 0.025, delta = 0.05)

# With interim analysis
dtl_tier_sim(nsim = 1000, n = 80, t = c(0.5, 1), rho = c(0.4, 0.2), q = 0.3, 
             alpha_s = 0.025, delta = 0.05)
}

}
