% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_summary.R
\name{rf_summary}
\alias{rf_summary}
\title{Random Forest Ensemble Summary}
\usage{
rf_summary(
  x = NULL,
  target_lab = NULL,
  data_train = NULL,
  data_test = NULL,
  data_all = NULL,
  test_size = 0.3,
  task = c("classification", "regression"),
  ntree = 500L,
  mtry = NULL,
  rf_control = NULL,
  show_var_imp = TRUE,
  show_rep_tree = TRUE,
  top_n_vars = 15L,
  total_w = 297,
  total_h = 210
)
}
\arguments{
\item{x}{Character. Dataset name/label. If NULL, inferred from data arguments.}

\item{target_lab}{Character. Name of the target column.}

\item{data_train}{Data frame. Training data.}

\item{data_test}{Data frame. Test data.}

\item{data_all}{Data frame. Full dataset.}

\item{test_size}{Numeric. Proportion for test split (default 0.3).}

\item{task}{Character. \code{"classification"} or \code{"regression"}.}

\item{ntree}{Integer. Number of trees (default 500).}

\item{mtry}{Integer or NULL. Variables per split.}

\item{rf_control}{A \code{ctree_control} object or NULL.}

\item{show_var_imp}{Logical. Show variable importance barplot (default TRUE).}

\item{show_rep_tree}{Logical. Show representative tree info (default TRUE).}

\item{top_n_vars}{Integer. How many top variables to show (default 15).}

\item{total_w}{Numeric. Page width in mm (default 297).}

\item{total_h}{Numeric. Page height in mm (default 210).}
}
\value{
A list (invisible) with:
\item{forest}{The fitted \code{cforest} object.}
\item{var_imp}{Named numeric vector of variable importance.}
\item{rep_tree_index}{Index of the representative tree.}
}
\description{
Fits a \code{partykit::cforest} and displays a multi-panel summary:
variable importance barplot, OOB error curve, and optionally a
representative tree (the tree with highest prediction agreement with
the full ensemble).
}
\examples{
\donttest{
rf_summary(
  data_train = train_covid,
  data_test = test_covid,
  target_lab = "Outcome",
  ntree = 50
)
}
}
