% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{partition_variance}
\alias{partition_variance}
\title{Partition variance in one variable due to another (EXPERIMENTAL)}
\usage{
partition_variance(object, which_response, n_times = 10)
}
\arguments{
\item{object}{Output from \code{\link{dsem}}}

\item{which_response}{string matching colnames from \code{tsdata}
identifying response variable}

\item{n_times}{Number of lags over which to calculate total effects}
}
\value{
A list with two elements:
\describe{
\item{total_variance}{A matrix of the total variance for each variable (column)
and each time from 1 to \code{n_times}}
\item{proportion_variance_explained}{A matrix of the proportion of variance
explained for variable \code{which_response} by each model variable
(column) and each time from 1 to \code{n_times}}
}
Note that in a model with lagged effects, the total_variance and variance_explained
will vary for each time (row), and the analyst might want to either choose a time
for which the value has stabilized.
}
\description{
Calculate the proportion of variance for a response variable that is
attributed to another set of predictor variables, calculated across lags from
from 0 (simultaneous effects) to a user-specified maximum lag.
}
\details{
This function calculates the variance for each variable and lag, and then
recalculates it when setting exogenous variance to zero for all variables except
\code{which_pred}.  It then calculates the ratio of the diagonal of these two.
This represents the proportion of variance in the full model that is attributable
to one or more variables.

This function is under development and may still change or be removed.
}
\examples{
# Simulate linear model
x = rnorm(100)
y = 1 + 1 * x + rnorm(100)
data = data.frame(x=x, y=y)

# Fit as DSEM
fit = dsem( sem = "x -> y, 0, beta",
            tsdata = ts(data),
            control = dsem_control(quiet=TRUE) )

# Apply
partition_variance( fit,
                    which_response = "y",
                    n_times = 10 )

}
