% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simfdata.R
\name{simfdata}
\alias{simfdata}
\title{simulation of survival data}
\usage{
simfdata(n, beta, fvar, bhdist = "weibull", X, fdist = "gamma", ...)
}
\arguments{
\item{n}{number of individual}

\item{beta}{vector of regression coefficient for coxph model}

\item{fvar}{frailty variance value(currently the function works for gamma frailty only)}

\item{bhdist}{distribution of survival time at baseline e.g. "weibull","exponential","llogistic"}

\item{X}{model matrix for the coxPH model with particular choice of beta}

\item{fdist}{distribution of frailty terms e.g. "gamma"}

\item{...}{user can assume the shape and scale parameter of baseline survival distribution}
}
\value{
simulated survival data for a single transition
}
\description{
function for simulation of survival data assuming the data comes from a parametric coxph model with gamma frailty distribution
}
\details{
The process for simulation of multistate survival data is described in our manuscript. As the process includes transition through different states and it involves simulating survival time in different transition. So we have demonstrated the code for simulation of simple survival model.
Suppose we want to simulate a survival data with parametric baseline hazard and parametric frailty model. The hazard model is as follows:
 \deqn{h_i(t)=z_ih_0(t)exp(\textbf{x}_i\beta)\;;i=1,2,3,...,n}
where the baseline survival time follow Weibull distribution and the hazard is
\deqn{h_0(t)=\rho \lambda t^{\rho-1}}. Similarly we can have Gompertz, log logistic distribution. The following are the formula for hazard and cummulative hazard function
For exponential: \eqn{h_0(t)=\lambda} and \eqn{H_0(t)=\lambda t}\;\eqn{\lambda>0}
    Gompertz: \eqn{h_0(t)=\lambda exp(\gamma t)} and \eqn{H_0(t)=\frac{\lambda}{\gamma}(exp(\gamma t)-1)};\eqn{\lambda,\gamma>0}
}
\examples{
\donttest{
##
n1<-1000
p1<-2
X1<-matrix(rnorm(n1*p1),n1,p1)
simulated_data<-simfdata(n=1000,beta=c(0.5,0.5),fvar=0.5,
X=X1)
##
}
}
\references{
Vishwakarma, G. K., Bhattacherjee, A., Rajbongshi, B. K., & Tripathy, A. (2024). Censored imputation of time to event outcome through survival proximity score method. \emph{Journal of Computational and Applied Mathematics}, 116103;

Bhattacharjee, A., Vishwakarma, G. K., Tripathy, A., & Rajbongshi, B. K. (2024). Competing risk multistate censored data modeling by propensity score matching method. \emph{Scientific Reports}, 14(1), 4368.
}
\seealso{
\link{cphGM}
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra K. Vishwakarma
}
