% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggroc_plot.R
\name{ggplot_roc}
\alias{ggplot_roc}
\title{Reciever Operating Curve}
\usage{
ggplot_roc(
  trns,
  model1,
  model2,
  data1,
  data2,
  folder_path = NULL,
  times = NULL
)
}
\arguments{
\item{trns}{transition number for the multistate model}

\item{model1}{fitted object from coxPH (before SPSM)}

\item{model2}{fitted object from coxPH (after SPSM)}

\item{data1}{dataset used for model1}

\item{data2}{dataset used for model2}

\item{folder_path}{default is NULL. if folder_path is provided then plots will be saved there automitically.}

\item{times}{default is NULL. time at which TP and FP values are calculated.}
}
\value{
returns roc plot for model1 and model2
}
\description{
this function provides roc plot for coxph model fitted before and after survival proximity score matching.
}
\examples{
\donttest{
##
library(mstate)
data(EBMTdata)
data(EBMTupdate)
tmat<-transMat(x=list(c(2,3),c(3),c()),
               names=c("Tx","Rec","Death"))
covs<-c("dissub","age","drmatch","tcd","prtime","x1","x2","x3","x4")
msbmt<-msprep(time=c(NA,"prtime","rfstime"),
              status=c(NA,"prstat","rfsstat"),
              data=EBMTdata,trans=tmat,keep=covs)
msbmt1<-msprep(time=c(NA,"prtime","rfstime"),
               status=c(NA,"prstat","rfsstat"),
               data=EBMTupdate,trans=tmat,keep=covs)
msph3<-coxph(Surv(time,status)~dissub+age+drmatch+tcd+
frailty(id,distribution='gamma'),data=msbmt[msbmt$trans==3,])
msph33<-coxph(Surv(Tstart,Tstop,status)~dissub+age +drmatch+ tcd+
frailty(id,distribution='gamma'),data=msbmt1[msbmt1$trans==3,])
ggplot_roc(trns=3,model1=msph3,model2=msph33,
           data1=msbmt,data2=msbmt1)
##
}
}
\references{
Vishwakarma, G. K., Bhattacherjee, A., Rajbongshi, B. K., & Tripathy, A. (2024). Censored imputation of time to event outcome through survival proximity score method. Journal of Computational and Applied Mathematics, 116103;

Bhattacharjee, A., Vishwakarma, G. K., Tripathy, A., & Rajbongshi, B. K. (2024). Competing risk multistate censored data modeling by propensity score matching method. Scientific Reports, 14(1), 4368.
}
\seealso{
\link{dscore}, \link{simfdata}, \link{cphGM}
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra Kumar Vishwakarma
}
