#' @title European Bone Marrow Transplantation data obtained from \code{mstate} r package
#' @docType data
#' @description A multi state dataset
#' @usage data(EBMTdata)
#' @source We acknowledge that this data set is obtained from the r package \code{mstate}. We have included four continuous covariates in the dataset to demonstrate SPSM method in multistate survival model.
#' @format a tibble of 13 columns and 2204 observations,
#' \describe{
#' \item{id}{id value for subjects}
#' \item{prtime}{Time in days from transplantation to platelet recovery or last follow-up}
#' \item{prstate}{Platelet recovery status; 1 = platelet recovery, 0 = censored}
#' \item{rfstime}{Time in days from transplantation to relapse or death or last follow-up (relapse-free survival time)}
#' \item{rfsstate}{Relapse-free survival status; 1 = relapsed or dead, 0 = censored}
#' \item{dissub}{Disease subclassification; factor with levels "AML", "ALL", "CML"}
#' \item{age}{Patient age at transplant; factor with levels "<=20", "20-40", ">40"}
#' \item{drmatch}{Donor-recipient gender match; factor with levels "No gender mismatch", "Gender mismatch"}
#' \item{tcd}{T-cell depletion; factor with levels "No TCD", "TCD"}
#' \item{x1,x2,x3,x4}{simulated covariate information used for SPSM}
#' }
#' @references
#' de Wreede, L. C., Fiocco, M., & Putter, H. (2011). mstate: an R package for the analysis of competing risks and multi-state models. Journal of statistical software, 38, 1-30.
#'
#' Vishwakarma, G. K., Bhattacherjee, A., Rajbongshi, B. K., & Tripathy, A. (2024). Censored imputation of time to event outcome through survival proximity score method. Journal of Computational and Applied Mathematics, 116103;
#'
#' Bhattacharjee, A., Vishwakarma, G. K., Tripathy, A., & Rajbongshi, B. K. (2024). Competing risk multistate censored data modeling by propensity score matching method. Scientific Reports, 14(1), 4368.
"EBMTdata"

#' @title European Bone Marrow Transplantation data obtained from \code{mstate} r package. This is the updated data obtained after applying SPSM.
#' @docType data
#' @description A multi state dataset
#' @usage data(EBMTupdate)
#' @source We acknowledge that this data set is obtained from the r package \code{mstate}. We have included four continuous covariates in the dataset to demonstrate SPSM method in multistate survival model.
#' @format a tibble of 13 columns and 2204 observations,
#' \describe{
#' \item{id}{id value for subjects}
#' \item{prtime}{Time in days from transplantation to platelet recovery or last follow-up}
#' \item{prstate}{Platelet recovery status; 1 = platelet recovery, 0 = censored}
#' \item{rfstime}{Time in days from transplantation to relapse or death or last follow-up (relapse-free survival time)}
#' \item{rfsstate}{Relapse-free survival status; 1 = relapsed or dead, 0 = censored}
#' \item{dissub}{Disease subclassification; factor with levels "AML", "ALL", "CML"}
#' \item{age}{Patient age at transplant; factor with levels "<=20", "20-40", ">40"}
#' \item{drmatch}{Donor-recipient gender match; factor with levels "No gender mismatch", "Gender mismatch"}
#' \item{tcd}{T-cell depletion; factor with levels "No TCD", "TCD"}
#' \item{x1,x2,x3,x4}{simulated covariate information used for SPSM}
#' }
#' @references
#' de Wreede, L. C., Fiocco, M., & Putter, H. (2011). mstate: an R package for the analysis of competing risks and multi-state models. Journal of statistical software, 38, 1-30.
#'
#' Vishwakarma, G. K., Bhattacherjee, A., Rajbongshi, B. K., & Tripathy, A. (2024). Censored imputation of time to event outcome through survival proximity score method. Journal of Computational and Applied Mathematics, 116103;
#'
#' Bhattacharjee, A., Vishwakarma, G. K., Tripathy, A., & Rajbongshi, B. K. (2024). Competing risk multistate censored data modeling by propensity score matching method. Scientific Reports, 14(1), 4368.
"EBMTupdate"

#' @title Simulated multistate data
#' @docType data
#' @description A simulated multi state dataset used for demonstration purpose.
#' @usage data(simulated_data)
#' @format a tibble of 13 columns and 2204 observations,
#' \describe{
#' \item{id}{id value for subjects}
#' \item{status}{survival status}
#' \item{time}{survival time}
#' \item{x1}{Numeric covariate}
#' \item{x2}{Numeric covariate}
#' \item{x3}{Numeric covariate}
#' \item{x4}{Numeric covariate}
#' }
#' @references
#' Vishwakarma, G. K., Bhattacherjee, A., Rajbongshi, B. K., & Tripathy, A. (2024). Censored imputation of time to event outcome through survival proximity score method. Journal of Computational and Applied Mathematics, 116103;
#'
#' Bhattacharjee, A., Vishwakarma, G. K., Tripathy, A., & Rajbongshi, B. K. (2024). Competing risk multistate censored data modeling by propensity score matching method. Scientific Reports, 14(1), 4368.
#'
"simulated_data"
