% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tte.R
\name{prior_tte}
\alias{prior_tte}
\title{Prior distribution for time-to-event outcomes}
\usage{
prior_tte(x, w, hr1, hr2, id1, id2)
}
\arguments{
\item{x}{integration variable}

\item{w}{weight for mixture prior distribution}

\item{hr1}{first assumed true treatment effect on HR scale for prior distribution}

\item{hr2}{second assumed true treatment effect on HR scale for prior distribution}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}
}
\value{
The output of the functions \code{Epgo_tte()} is the expected number of participants in phase III with conservative decision rule and sample size calculation.
}
\description{
If we do not assume the treatment effects to be fixed, i.e. \code{fixed = FALSE},
the function \code{prior_tte} allows us to model the treatment effect following a prior distribution.
For more details concerning the definition of a prior distribution, see the \href{https://sterniii3.github.io/drugdevelopR/articles/Introduction-to-drugdevelopR.html}{vignette on priors}
as well as the \href{https://web.imbi.uni-heidelberg.de/prior/}{Shiny app}.
}
\examples{
res <- prior_tte(x = 0.5, w = 0.5, hr1 = 0.69, hr2 = 0.88, id1 = 240, id2 = 420)
}
\keyword{internal}
