% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_helpers.R
\name{extract_stochastic_intervention}
\alias{extract_stochastic_intervention}
\title{Compute weighted sum of outcomes.}
\usage{
extract_stochastic_intervention(z, r, s)
}
\arguments{
\item{z}{a vector of doses}

\item{r}{a vector of outcomes}

\item{s}{a set of weights, summing to 1}
}
\value{
the inner product of s and r
}
\description{
Compute weighted sum of outcomes.
}
\examples{
# dose vector
dose <- c(0, 0.1, 0.4)
# outcome vector
outcome <- c(1, 1.1, 1.5)
# weight vector
weight = c(0.3, 0.4, 0.3)
theta <- extract_stochastic_intervention(z = dose, r = outcome, s = weight)
}
