#' Summarize a fitted Dynamic Local Level Model object
#'
#' Provides a brief summary of the fitted dynamic local level model, including
#' parameter estimates and log-likelihood.
#'
#' @param object An object of class \code{dllm}, as returned by \code{\link{dllm}}.
#' @param ... Additional arguments (not used).
#' @return The \code{object} is returned invisibly.
#' @export
summary.dllm <- function(object, ...) {
  cat("Dynamic Linear Model Results\n")
  cat("============================\n")
  # Model Structure
  cat("Model Structure:\n")
  cat("- Observation columns:", paste(object$obs_cols, collapse = ", "), "\n")
  cat("- Latent state dimension:", ncol(object$model$GG), "\n")
  cat("- Observation dimension:", nrow(object$model$FF), "\n")

  # Fit Statistics
  cat("Fit Statistics:\n")
  cat(sprintf("Log-likelihood: %.2f\n", object$logLik))
  cat(sprintf("AIC: %.2f\n", object$aic))
  cat(sprintf("BIC: %.2f\n", object$bic))
  cat(sprintf("Convergence: %s\n\n",
              ifelse(object$convergence == 0, "Achieved", "Failed")))

  # Parameters
  cat("Estimated Parameters:\n")
  print(object$parameters)  # Print named parameters

  invisible(object)
}
