% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlim.R
\name{dlim}
\alias{dlim}
\title{Fit DLIM}
\usage{
dlim(
  y,
  x,
  modifiers,
  z = NULL,
  df_m = NULL,
  df_l,
  penalize = TRUE,
  pen_fn = "ps",
  mod_args = NULL,
  lag_args = NULL,
  fit_fn = "gam",
  model_type = "nonlinear",
  ID = NULL,
  ...
)
}
\arguments{
\item{y}{vector of response values (class "\code{numeric}")}

\item{x}{matrix of exposure history (columns) for individuals (rows) (class "\code{matrix}")}

\item{modifiers}{vector of modifying values (class "\code{numeric}")}

\item{z}{matrix of covariates, not including the modifier (class "\code{matrix}")}

\item{df_m}{degrees of freedom for modifier basis. Cannot specify for linear modification (model_type = "linear") (class "\code{numeric}")}

\item{df_l}{degrees of freedom for exposure time basis (class "\code{numeric}")}

\item{penalize}{\code{TRUE} to penalize model (class "\code{logical}")}

\item{pen_fn}{if penalizing, can specify "ps" for penalized B-splines or "cr" for cubic regression splines with penalties on second derivatives}

\item{mod_args}{a list of additional arguments for the spline function (must be named by argument)}

\item{lag_args}{a list of additional arguments for the spline function (must be named by argument)}

\item{fit_fn}{specify "gam" to use the \code{gam} function for data sets that are not very large, and specify "bam" to use the \code{bam} function for data sets that are very large. Default will fit using \code{gam}. (class "\code{character}")}

\item{model_type}{"linear" for a DLIM with linear interaction (linear modifier basis), "quadratic" for a DLIM with quadratic interaction (quadratic modifier basis), "nonlinear" for a DLIM with non-linear interaction (spline modifier basis)}

\item{ID}{group identifier for random intercept, only supported for penalized models}

\item{...}{Other arguments to pass to model fitting function}
}
\value{
This function returns a list that is an object of class "\code{dlim}" with the following components
\item{cb}{cross-basis (class "\code{matrix}")}
\item{fit}{model object (class "\code{lm}", "\code{glm}", "\code{gam}")}
\item{modifiers}{modifying values (class "\code{numeric}")}
\item{call}{model call}
}
\description{
Fit distributed lag interaction model
}
\examples{
library(dlim)
data("ex_data")
dlim_fit <- dlim(y = ex_data$y, 
                 x = ex_data$exposure, 
                 modifier = ex_data$modifier, 
                 z = ex_data$z, 
                 df_m = 10, 
                 df_l = 10)
dlim_pred <- predict(dlim_fit, 
                     newdata = 0.5, 
                     type="CE")
}
\seealso{
Type \code{vignette('dlimOverview')} for a detailed description.

\link[dlim]{predict.dlim}

\link[dlim]{plot_cumulative}

\link[dlim]{plot_DLF}
}
