% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.multifor.R
\name{predict.multifor}
\alias{predict.multifor}
\title{Random forest prediction using a saved forest from \code{multifor}}
\usage{
\method{predict}{multifor}(
  object,
  data = NULL,
  predict.all = FALSE,
  num.trees = object$num.trees,
  type = "response",
  seed = NULL,
  num.threads = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{\code{multifor} object.}

\item{data}{New test data of class \code{data.frame}.}

\item{predict.all}{Return individual predictions for each tree instead of aggregated predictions for all trees. Return a matrix (sample x tree) for classification, a 3d array for probability estimation (sample x class x tree).}

\item{num.trees}{Number of trees used for prediction. The first \code{num.trees} in the forest are used.}

\item{type}{Type of prediction. If "response" (default), the predicted classes (classification) or 
predicted probabilities (probability estimation) are returned. If "terminalNodes", the IDs of the terminal 
node in each tree for each observation in the given dataset are returned.}

\item{seed}{Random seed. Default is \code{NULL}, which generates the seed from \code{R}. Set to \code{0} to ignore the \code{R} seed. The seed is used in case of ties in classification mode.}

\item{num.threads}{Number of threads. Default is number of CPUs available.}

\item{verbose}{Verbose output on or off.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Object of class \code{multifor.prediction} with elements
  \tabular{ll}{
      \code{predictions}    \tab Predicted classes/values (only for classification and regression)  \cr
      \code{num.trees}   \tab Number of trees. \cr
      \code{num.independent.variables} \tab Number of independent variables. \cr
      \code{num.samples}     \tab Number of samples. \cr
      \code{treetype}    \tab Type of forest/tree. Classification or probability.
  }
}
\description{
Prediction with new data and a saved forest from \code{\link{multifor}}.
}
\details{
This package is a fork of the R package 'ranger' that implements random forests using an
efficient C++ implementation. More precisely, 'diversityForest' was written by modifying
the code of 'ranger', version 0.11.0.
}
\references{
\itemize{
  \item Hornung, R. (2022). Diversity forests: Using split sampling to enable innovative complex split procedures in random forests. SN Computer Science 3(2):1, <\doi{10.1007/s42979-021-00920-1}>.
  \item Wright, M. N., Ziegler, A. (2017). ranger: A fast Implementation of Random Forests for High Dimensional Data in C++ and R. Journal of Statistical Software 77:1-17, <\doi{10.18637/jss.v077.i01}>.
  \item Wager, S., Hastie T., & Efron, B. (2014). Confidence Intervals for Random Forests: The Jackknife and the Infinitesimal Jackknife. Journal of Machine Learning Research 15:1625-1651.
  \item Meinshausen (2006). Quantile Regression Forests. Journal of Machine Learning Research 7:983-999.
  }
}
\seealso{
\code{\link{multifor}}
}
\author{
Marvin N. Wright
}
