validate_args_distfreereg_function <-
  function(Y, X, test_mean, covariance, theta_init, ordering,
           stat, B, override, verbose, control, extra_arg_list){
    stopifnot(is.function(test_mean))
    
    validate_extra_arg_list(extra_arg_list, "distfreereg.function()")
    
    if(!is.null(control))
      validate_named_list(control, valid_names = c("matsqrt_tol", "solve_tol",
                                                   "qr_tol", "orth_tol", "trans_tol",
                                                   "sym_tol", "sym_tol1",
                                                   "jacobian_args",
                                                   "optimization_fun",
                                                   "fun_to_optimize_arg",
                                                   "optimization_args",
                                                   "theta_hat_name", "theta_init_arg",
                                                   "data", "return_on_error"))# "data" only here for ordering
    
    control <- combine_lists(control, default_distfreereg_tol())
    validate_control_tols(control)
    
    Y <- validate_Y(Y = Y, verbose = verbose)
    n <- length(Y)
    
    X <- validate_X(X = X, verbose = verbose)
    
    # Verify that X and Y dimensions match.
    if(!is.null(X) && nrow(X) != n)
      stop("The number of rows in X must be the length of Y: nrow(X) is ",
           nrow(X), ", but length(Y) is ", n)
    
    
    # Verify that override is a named list.
    if(!is.null(override)){
      validate_named_list(override, valid_names = c("J", "fitted_values",
                                                    "res_order", "theta_hat",
                                                    "r", "mcsim_stats"))
      
      if(!is.null(override[["theta_hat"]]))
        validate_numeric(override[["theta_hat"]],
                         message = "override[['theta_hat']] failed numeric validation: ")
      
      if(!is.null(override[["J"]]) && !is.null(override[["r"]]) &&
         !all(dim(as.matrix(override[["J"]])) == dim(as.matrix(override[["r"]]))))
        stop("as.matrix(override[['J']]) and as.matrix(override[['r']]) must have the same dimensions")
    }
    
    if(!is.null(override[["fitted_values"]])){
      validate_numeric(override[["fitted_values"]], len = n,
                       message = "override[['fitted_values']] failed numeric validation: ")
    }
    
    if(!is.null(override[["J"]])){
      validate_numeric(override[["J"]], message = "override[['J']] failed numeric validation: ")
      override[["J"]] <- tryCatch(as.matrix(override[["J"]]),
                                  error = function(e) stop("Error converting override[['J']] to a matrix: ", e))
      if(nrow(as.matrix(override[["J"]])) != n) stop("nrow(as.matrix(override[['J']])) must be equal to length(Y)") 
    }
    
    if(is.null(override[["theta_hat"]])){
      validate_numeric(x = theta_init, min_len = 1, message = "theta_init failed numeric validation: ")
    } else {
      # This is just so function output is verified at theta_hat below.
      theta_init <- override[["theta_hat"]]
    }
    if(is.null(names(theta_init))) names(theta_init) <- paste0("theta", seq_along(theta_init))
    
    validate_mean_function_arg_names(f = test_mean)
    if(is.null(X)){
      if(any(c("x", "X") %in% names(formals(test_mean))))
        stop("X must be supplied if 'x' or 'X' is an argument of test_mean")
      if(length(theta_init) != 1) stop("theta_init must have length 1 when X is NULL")
    } else {
      if(!any(c("x", "X") %in% names(formals(test_mean))))
        stop("'x' or 'X' must be an argument of test_mean when X is not NULL")
    }
    
    validate_function_behavior(f = test_mean, X = X, n = n, theta = theta_init)
    
    if(!is.null(override[["theta_hat"]])) theta_init <- NULL

    
    # Validate covariance list.
    validate_covariance_list(covariance, n = n, sym_tol = control[["sym_tol"]],
                             sym_tol1 = control[["sym_tol1"]])
    
    # Deal with optimization
    optimization_args <- control[["optimization_args"]]
    if(!is.null(optimization_args) && !is.list(optimization_args))
      stop("control[['optimization_args']] must be a list")
    if(is.null(control[["optimization_fun"]])){
      if(any(!is.null(control[["fun_to_optimize_arg"]]),
             !is.null(control[["theta_init_arg"]]),
             !is.null(control[["theta_hat_name"]])))
        warning("No alternative optimization function specified; using optim()",
                " by default, ignoring 'fun_to_optimize_arg', 'theta_init_arg', and 'theta_hat_name'")
      optimization_fun <- optim
      optimization_args <- combine_lists(optimization_args, list(method = "BFGS"))
      theta_init_arg <- "par"
      theta_hat_name <- "par"
      fun_to_optimize_arg <- "fn"
    } else {
      optimization_fun <- control[["optimization_fun"]]
      theta_init_arg <- control[["theta_init_arg"]]
      theta_hat_name <- control[["theta_hat_name"]]
      fun_to_optimize_arg <- control[["fun_to_optimize_arg"]]
      if(!is.function(optimization_fun))
        stop("control[['optimization_fun']] must be a function")
    }
    if(is.character(theta_init_arg)){
      if(length(theta_init_arg) != 1)
        stop("control[['theta_init_arg']] must have length 1")
      if(!(theta_init_arg %in% names(formals(optimization_fun))))
        stop("control[['theta_init_arg']] must be the name of an argument of optimization_fun")
    } else {
      stop("control[['theta_init_arg']] must be a character string")
    }
    if(is.character(fun_to_optimize_arg)){
      if(length(fun_to_optimize_arg) != 1)
        stop("control[['fun_to_optimize_arg']] must have length 1")
      if(!(fun_to_optimize_arg %in% names(formals(optimization_fun))))
        stop("control[['fun_to_optimize_arg']] must be the name of an argument of optimization_fun")
    } else {
      stop("control[['fun_to_optimize_arg']] must be a character string")
    }
    if(!is.character(theta_hat_name)){
      stop("control[['theta_hat_name']] must be a character vector of length 1")
    } else {
      if(length(theta_hat_name) != 1) stop("control[['theta_hat_name']] must have length 1")
    }
    
    optimization_args[[theta_init_arg]] <- theta_init
    
    # Straight-forward verification of a few more arguments.
    jacobian_args <- control[["jacobian_args"]]
    if(!is.null(jacobian_args) && !is.list(jacobian_args))
      stop("jacobian_args must be a list")
    validate_numeric(x = B, pos_int = TRUE, len = 1)
    B <- as.integer(B)
    
    
    # Validate the observation ordering specification.
    if(is.null(override[["res_order"]])){
      if(is.list(ordering)){
        validate_order_columns(X, ordering)
      } else {
        if(length(ordering) > 1) stop("ordering method specification must have length one, ",
                                      "or be a list of column specifications")
        strict_match(ordering, c("asis", "optimal", "simplex", "natural"))
      }
    }
    
    return(list(Y = Y, X = X, n = n, covariance = covariance,
                matsqrt_tol = control[["matsqrt_tol"]], solve_tol = control[["solve_tol"]],
                # qr_tol = control[["qr_tol"]], orth_tol = control[["orth_tol"]],
                # trans_tol = control[["trans_tol"]],
                optimization_fun = optimization_fun, optimization_args = optimization_args,
                theta_hat_name = theta_hat_name, fun_to_optimize_arg = fun_to_optimize_arg,
                jacobian_args = jacobian_args, B = B))
  }
